<!DOCTYPE html>
    <html lang="id">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <?php if(auth()->guard()->check()): ?>
            <meta name="user-authenticated" content="true">
            <meta name="user-type" content="<?php echo e(Auth::user()->user_type); ?>">
        <?php endif; ?>
        <title><?php echo $__env->yieldContent('title', 'POLJAM TECH'); ?></title>
        <!-- Favicon -->
        <link rel="icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <link rel="shortcut icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <link rel="icon" type="image/jpeg" sizes="32x32" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <link rel="icon" type="image/jpeg" sizes="16x16" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon-logo.jpeg')); ?>">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link rel="stylesheet" href="https://cdn.lineicons.com/4.0/lineicons.css">
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
        <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>?v=<?php echo e(time()); ?>">
        <style>
            /* Force override Tailwind untuk category scroll buttons - Sama seperti navbar bg-blue-600 */
            .category-scroll-btn:hover,
            .category-scroll-left:hover,
            .category-scroll-right:hover,
            button.category-scroll-btn:hover,
            button.category-scroll-left:hover,
            button.category-scroll-right:hover {
                opacity: 1 !important;
                background-color: #2563eb !important; /* Blue-600 - sama seperti navbar bg-blue-600 */
                background: #2563eb !important;
                filter: none !important; /* Hilangkan filter yang mungkin membuat redup */
            }
            
            /* Mobile specific - SOLID seperti navbar bg-blue-600 */
            @media (max-width: 640px) {
                .category-scroll-btn:active,
                .category-scroll-btn:hover,
                .category-scroll-left:active,
                .category-scroll-left:hover,
                .category-scroll-right:active,
                .category-scroll-right:hover,
                button.category-scroll-btn:active,
                button.category-scroll-btn:hover,
                button.category-scroll-left:active,
                button.category-scroll-left:hover,
                button.category-scroll-right:active,
                button.category-scroll-right:hover,
                /* Tambahan selector untuk memastikan override */
                button.bg-black\/70.category-scroll-btn:hover,
                button.bg-black\/70.category-scroll-left:hover,
                button.bg-black\/70.category-scroll-right:hover,
                button.bg-black\/70.hover\:bg-blue-600.category-scroll-btn:hover,
                button.bg-black\/70.hover\:bg-blue-600.category-scroll-left:hover,
                button.bg-black\/70.hover\:bg-blue-600.category-scroll-right:hover {
                    opacity: 1 !important;
                    background-color: #2563eb !important; /* Blue-600 - SOLID seperti navbar */
                    background: #2563eb !important; /* SOLID color */
                    /* Hilangkan semua transparansi */
                    filter: none !important;
                    -webkit-background-color: #2563eb !important;
                    -moz-background-color: #2563eb !important;
                    background-image: none !important;
                    box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3) !important;
                }
            }
        </style>
        <style>
            /* Alpine.js x-cloak - Hide elements until Alpine.js is loaded */
            [x-cloak] { display: none !important; }
            
            /* Tombol Scroll to Top */
            #scrollTopBtn {
                position: fixed;
                bottom: 30px;
                right: 30px;
                width: 45px;
                height: 45px;
                background-color: black;
                color: white;
                border-radius: 8px;
                display: none;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                transition: all 0.3s ease;
                z-index: 50;
            }

            #scrollTopBtn:hover {
                background-color: #2563eb;
                transform: translateY(-3px);
            }

            /* Bottom Navigation Spacer - Adjust scroll button position on mobile */
            @media (max-width: 768px) {
                #scrollTopBtn {
                    bottom: 90px;
                }
            }
        </style>
    </head>

    <body class="bg-gray-100">

        <!-- Header + Navbar Sticky -->
        <div class="sticky top-0 z-50">
            <?php echo $__env->make('partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <!-- Hero Section (opsional) -->
        <?php if (! empty(trim($__env->yieldContent('hero')))): ?>
            <section class="content-wrapper mt-6 px-4 md:px-0" style="overflow: visible;">
                <?php echo $__env->yieldContent('hero'); ?>
            </section>
        <?php endif; ?>

        <!-- Main Content -->
        <main class="content-wrapper py-4 md:py-8 px-4 md:px-0 pb-20 md:pb-8" style="overflow: visible;">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Footer -->
        <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Bottom Navigation (Mobile Only) -->
        <?php echo $__env->make('partials.bottom-nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Tombol Scroll ke Atas -->
        <button id="scrollTopBtn" onclick="scrollToTop()">
            <i class="fas fa-chevron-up text-lg"></i>
        </button>

        <script src="<?php echo e(asset('js/slider.js')); ?>"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <!-- Midtrans Snap JS -->
        <?php if(config('midtrans.client_key')): ?>
        <script src="<?php echo e(config('midtrans.is_production') ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js'); ?>" 
                data-client-key="<?php echo e(config('midtrans.client_key')); ?>"
                onerror="console.error('Gagal memuat Midtrans Snap JS')">
        </script>
        <?php else: ?>
        <script>
            console.warn('Midtrans Client Key belum dikonfigurasi');
        </script>
        <?php endif; ?>
        
        <?php if(auth()->guard()->check()): ?>
            <?php if(Auth::user()->user_type === 'admin'): ?>
                <!-- Admin Notification System -->
                <meta name="user-type" content="admin">
                <script src="<?php echo e(asset('js/notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
                <script>
                    // Ensure admin notification system is initialized for navbar
                    document.addEventListener('DOMContentLoaded', function() {
                        if (!window.notificationSystem) {
                            console.log('[Navbar] Initializing NotificationSystem for admin...');
                            window.notificationSystem = new NotificationSystem();
                        }
                    });
                </script>
            <?php elseif(Auth::user()->user_type === 'supervisor'): ?>
                <!-- Supervisor Notification System -->
                <meta name="user-type" content="supervisor">
                <script src="<?php echo e(asset('js/notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
                <script>
                    // Ensure supervisor notification system is initialized for navbar
                    document.addEventListener('DOMContentLoaded', function() {
                        if (!window.notificationSystem) {
                            console.log('[Navbar] Initializing NotificationSystem for supervisor...');
                            window.notificationSystem = new NotificationSystem();
                        }
                    });
                </script>
            <?php elseif(Auth::user()->user_type === 'teknisi'): ?>
                <!-- Teknisi Notification System -->
                <meta name="user-type" content="teknisi">
                <script src="<?php echo e(asset('js/teknisi-notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
            <?php else: ?>
                <!-- User Notification System -->
                <meta name="user-type" content="user">
                <script src="<?php echo e(asset('js/user-notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>
                <script>
                    // Ensure user notification system is initialized
                    document.addEventListener('DOMContentLoaded', function() {
                        if (!window.userNotificationSystem && document.querySelector('meta[name="user-authenticated"]')) {
                            console.log('[Navbar] Initializing UserNotificationSystem...');
                            window.userNotificationSystem = new UserNotificationSystem();
                        }
                    });
                </script>
            <?php endif; ?>
        <?php endif; ?>

        <script>
            // Tombol scroll ke atas
            const scrollTopBtn = document.getElementById("scrollTopBtn");

            window.addEventListener("scroll", () => {
                if (window.scrollY > 300) {
                    scrollTopBtn.style.display = "flex";
                } else {
                    scrollTopBtn.style.display = "none";
                }
            });

            function scrollToTop() {
                window.scrollTo({
                    top: 0,
                    behavior: "smooth"
                });
            }
        </script>

        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>

    </html>

    </html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/layouts/main.blade.php ENDPATH**/ ?>