<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Dashboard Teknisi - POLJAM TECH'); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="shortcut icon" type="image/jpeg" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="32x32" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <link rel="icon" type="image/jpeg" sizes="16x16" href="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon-logo.jpeg')); ?>">
    
    <!-- CRITICAL: Restore sidebar state IMMEDIATELY - Must be first script -->
    <script>
    (function() {
        // Run immediately, blocking - before any rendering
        const savedState = localStorage.getItem('teknisiSidebarState');
        const isHidden = savedState === 'hidden';
        
        // Inject blocking style immediately to prevent ANY flash
        const style = document.createElement('style');
        style.id = 'sidebar-blocking-style';
        style.textContent = `
            #sidebar { 
                transition: none !important; 
                transform: ${isHidden ? 'translateX(-100%)' : 'translateX(0)'} !important;
            }
            #mainContent { 
                transition: none !important; 
                margin-left: ${isHidden ? '0' : '256px'} !important;
            }
            #teknisiNavbar {
                transition: none !important;
                left: ${isHidden ? '0' : '256px'} !important;
            }
        `;
        document.head.insertBefore(style, document.head.firstChild);
        
        // Set flag for later use
        window.__sidebarState = { isHidden: isHidden, restored: false };
    })();
    </script>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    
    <!-- SweetAlert2 - Must load first -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- SweetAlert Helper - Inline untuk memastikan selalu tersedia -->
    <script>
    // SweetAlert Configuration
    const SwalConfig = {
        confirmButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200 shadow-lg hover:shadow-xl' },
        cancelButton: { class: 'px-6 py-2.5 rounded-lg font-semibold transition-all duration-200' },
        popup: { class: 'rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700' }
    };

    // Modern Confirm Dialog
    function showConfirm(options) {
        const {
            title = 'Konfirmasi',
            text = 'Apakah Anda yakin?',
            confirmText = 'Ya, Lanjutkan',
            cancelText = 'Batal',
            icon = 'question',
            confirmColor = '#3b82f6',
            onConfirm = null,
            onCancel = null,
            showLoader = false
        } = options;

        return Swal.fire({
            title: title,
            text: text,
            icon: icon,
            showCancelButton: true,
            confirmButtonColor: confirmColor,
            cancelButtonColor: '#6b7280',
            confirmButtonText: `<i class="fas fa-check mr-2"></i>${confirmText}`,
            cancelButtonText: `<i class="fas fa-times mr-2"></i>${cancelText}`,
            reverseButtons: true,
            allowOutsideClick: !showLoader,
            allowEscapeKey: !showLoader,
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                cancelButton: SwalConfig.cancelButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
            didOpen: () => { if (showLoader) Swal.showLoading(); }
        }).then((result) => {
            if (result.isConfirmed && onConfirm) {
                onConfirm(result);
            } else if (result.isDismissed && onCancel) {
                onCancel(result);
            }
            return result;
        });
    }

    // Modern Success Notification
    function showSuccess(message, title = 'Berhasil!', duration = 3000) {
        return Swal.fire({
            icon: 'success',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Error Notification
    function showError(message, title = 'Terjadi Kesalahan!', duration = 4000) {
        return Swal.fire({
            icon: 'error',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-times mr-2"></i>Tutup',
            confirmButtonColor: '#ef4444',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Warning Notification
    function showWarning(message, title = 'Peringatan!', duration = 4000) {
        return Swal.fire({
            icon: 'warning',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: true,
            confirmButtonText: '<i class="fas fa-check mr-2"></i>Mengerti',
            confirmButtonColor: '#f59e0b',
            customClass: {
                popup: SwalConfig.popup.class,
                confirmButton: SwalConfig.confirmButton.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Info Notification
    function showInfo(message, title = 'Informasi', duration = 3000) {
        return Swal.fire({
            icon: 'info',
            title: title,
            text: message,
            timer: duration,
            timerProgressBar: true,
            showConfirmButton: false,
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
            buttonsStyling: false,
        });
    }

    // Modern Loading Indicator
    function showLoading(title = 'Memproses...', text = 'Harap tunggu sebentar') {
        return Swal.fire({
            title: title,
            text: text,
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => { Swal.showLoading(); },
            customClass: {
                popup: SwalConfig.popup.class,
                title: 'text-xl font-bold text-gray-900 dark:text-white',
                htmlContainer: 'text-gray-700 dark:text-gray-300',
            },
        });
    }

    // Export functions globally
    window.showConfirm = showConfirm;
    window.showSuccess = showSuccess;
    window.showError = showError;
    window.showWarning = showWarning;
    window.showInfo = showInfo;
    window.showLoading = showLoading;
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        /* Alpine.js x-cloak - Hide elements until Alpine is initialized */
        [x-cloak] { 
            display: none !important; 
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Dark mode custom styles */
        .dark {
            color-scheme: dark;
        }

        /* Ensure dark mode works properly */
        html.dark {
            background-color: #111827;
        }

        html.dark body {
            background-color: #111827;
        }

        /* Prevent content overflow */
        #mainContent {
            max-width: 100vw;
            box-sizing: border-box;
            overflow-x: hidden;
        }
        
        body, html {
            overflow-x: hidden;
        }
        
        main, main > div {
            max-width: 100%;
            box-sizing: border-box;
        }
        
        /* Smooth transitions for sidebar toggle (not on load) */
        #sidebar {
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        #mainContent {
            transition: margin-left 0.3s cubic-bezier(0.4, 0, 0.2, 1), width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Smooth overlay transition */
        #sidebarOverlay {
            transition: opacity 0.3s cubic-bezier(0.4, 0, 0.2, 1), visibility 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        /* Consistent spacing between navbar and content */
        /* Navbar: py-2.5 sm:py-3 + icon + button padding = ~3.125rem mobile, ~3.375rem desktop */
        /* Add comfortable spacing so content doesn't feel cramped */
        main > div {
            padding-top: 5rem !important; /* Navbar height (~3.125rem) + comfortable spacing (1.875rem) */
        }
        
        @media (min-width: 640px) {
            main > div {
                padding-top: 5.25rem !important; /* Navbar height (~3.375rem) + comfortable spacing (1.875rem) */
            }
        }
        
        @media (min-width: 1024px) {
            main > div {
                padding-top: 5.5rem !important; /* Extra spacing on larger screens for better readability */
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="bg-gray-100 dark:bg-gray-900 transition-colors duration-300">
    <!-- Sidebar -->
    <?php echo $__env->make('teknisi.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div id="mainContent" class="ml-0 lg:ml-64 flex flex-col min-h-screen">
        <?php echo $__env->make('teknisi.partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="flex-1 overflow-x-hidden w-full" style="min-width: 0;">
            <div class="p-4 sm:p-6 md:p-8 lg:p-12">
                <div class="w-full max-w-full" style="min-width: 0;">
                    <!-- Flash Notifications -->
                    <?php echo $__env->make('partials.flash-notifications', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    
                    <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                        <?php echo $__env->yieldContent('content'); ?>
                    <?php else: ?>
                        <p class="text-gray-600 dark:text-gray-300">Selamat datang di dashboard teknisi.</p>
                    <?php endif; ?>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <?php echo $__env->make('teknisi.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Restore sidebar state and remove blocking style -->
    <script>
    (function() {
        function restoreSidebarState() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            
            if (!sidebar || !mainContent) {
                requestAnimationFrame(restoreSidebarState);
                return;
            }
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                // Remove blocking style
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                if (window.__sidebarState) window.__sidebarState.restored = true;
                return;
            }
            
            // Get saved state (from early script or localStorage)
            const savedState = window.__sidebarState ? window.__sidebarState.isHidden : (localStorage.getItem('teknisiSidebarState') === 'hidden');
            
            // Ensure no transition during restore
            sidebar.style.transition = 'none';
            mainContent.style.transition = 'none';
            
            if (savedState) {
                sidebar.classList.add('-translate-x-full');
                sidebar.style.transform = 'translateX(-100%)';
                mainContent.classList.remove('ml-64');
                mainContent.classList.add('ml-0');
                mainContent.style.marginLeft = '0';
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.style.transform = '';
                mainContent.classList.remove('ml-0');
                mainContent.classList.add('ml-64');
                mainContent.style.marginLeft = '';
            }
            
            // Update navbar position immediately
            const navbar = document.getElementById('teknisiNavbar');
            if (navbar) {
                if (savedState) {
                    navbar.style.left = '0';
                } else {
                    navbar.style.left = '256px';
                }
            }
            
            // Remove blocking style and re-enable smooth transitions after a delay
            setTimeout(function() {
                const blockingStyle = document.getElementById('sidebar-blocking-style');
                if (blockingStyle) blockingStyle.remove();
                sidebar.style.transition = '';
                mainContent.style.transition = '';
                if (window.__sidebarState) window.__sidebarState.restored = true;
            }, 100);
        }
        
        // Run as soon as possible
        if (document.body) {
            restoreSidebarState();
        } else {
            document.addEventListener('DOMContentLoaded', restoreSidebarState);
        }
    })();
    </script>

    <!-- Simple Layout Handler - Fix content width on zoom/resize -->
    <script>
    (function() {
        function fixLayout() {
            const mainContent = document.getElementById('mainContent');
            const sidebar = document.getElementById('sidebar');
            if (!mainContent || !sidebar) return;
            
            const isMobile = window.innerWidth < 1024;
            if (isMobile) {
                mainContent.style.width = '';
                mainContent.style.maxWidth = '';
                return;
            }
            
            const viewportWidth = window.innerWidth;
            const sidebarWidth = 256;
            const isHidden = sidebar.classList.contains('-translate-x-full');
            
            if (isHidden) {
                mainContent.style.width = viewportWidth + 'px';
                mainContent.style.maxWidth = viewportWidth + 'px';
                mainContent.style.marginLeft = '0';
            } else {
                mainContent.style.width = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.maxWidth = (viewportWidth - sidebarWidth) + 'px';
                mainContent.style.marginLeft = '';
            }
        }
        
        // Make it globally accessible
        window.fixTeknisiLayout = fixLayout;
        
        let resizeTimeout;
        window.addEventListener('resize', function() {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(fixLayout, 100);
        });
        
        // Fix on load (after sidebar state is restored)
        function initLayout() {
            if (window.__sidebarState && window.__sidebarState.restored) {
                fixLayout();
            } else {
                setTimeout(initLayout, 50);
            }
        }
        
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function() {
                setTimeout(initLayout, 100);
            });
        } else {
            setTimeout(initLayout, 150);
        }
    })();
    </script>

    <!-- Teknisi Notification System (same pattern as admin/supervisor) -->
    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="<?php echo e(asset('js/teknisi-notifications.js')); ?>?v=<?php echo e(time()); ?>"></script>

    <!-- Stack untuk scripts dari views -->
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <!-- Yield untuk scripts dari views -->
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>


<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/layouts/teknisi.blade.php ENDPATH**/ ?>