

<?php $__env->startSection('title', 'Jurnal Umum'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Jurnal Umum</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Input dan pengelolaan data jurnal umum dengan format Excel-like
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <button onclick="openInputModal()" class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-plus mr-2 text-xs"></i>
                        Input Data
                    </button>
                    <button onclick="generateReport()" class="inline-flex items-center justify-center px-3 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-sync-alt mr-2 text-xs"></i>
                        Refresh Data
                    </button>
                    <button onclick="exportReport('excel')" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </button>
                    <button onclick="exportReport('pdf')" class="inline-flex items-center justify-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-pdf mr-2 text-xs"></i>
                        Export PDF
                    </button>
                </div>
            </div>
        </div>

        <!-- Notifikasi Modern -->
        <?php if (isset($component)) { $__componentOriginal08a8786da7acaa0d17ad66b17276ca17 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-notification','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-notification'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $attributes = $__attributesOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__attributesOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17)): ?>
<?php $component = $__componentOriginal08a8786da7acaa0d17ad66b17276ca17; ?>
<?php unset($__componentOriginal08a8786da7acaa0d17ad66b17276ca17); ?>
<?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg text-sm">
                <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="mb-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg text-sm">
                <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Report Display Section -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="p-2 bg-green-100 dark:bg-green-900/40 rounded-lg mr-2">
                            <i class="fas fa-file-alt text-green-600 dark:text-green-400 text-sm"></i>
                        </div>
                        <h3 class="text-base font-semibold text-gray-800 dark:text-white">Laporan Jurnal Umum</h3>
                    </div>
                </div>
            </div>

            <div id="reportContent" class="p-6">
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                        <i class="fas fa-spinner fa-spin text-3xl text-blue-600 dark:text-blue-400"></i>
                    </div>
                    <p class="text-blue-600 dark:text-blue-400 font-medium mb-1">Memuat Laporan...</p>
                    <p class="text-blue-500 dark:text-blue-500 text-sm">Mengambil data dari database</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Input Data Modal -->
    <div id="inputModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
        <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-7xl shadow-lg rounded-lg bg-white dark:bg-gray-800">
            <!-- Modal Header -->
            <div class="flex items-center justify-between pb-4 border-b border-gray-200 dark:border-gray-600 mb-4">
                <div class="flex items-center">
                    <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                        <i class="fas fa-table text-blue-600 dark:text-blue-400 text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Input Jurnal Umum (Format Excel-like)</h3>
                </div>
                <button onclick="closeInputModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="mb-4">
                <div class="flex items-center justify-end gap-2 mb-4">
                    <button onclick="addNewRow()" class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-plus mr-2 text-xs"></i>
                        Tambah Baris
                    </button>
                    <button onclick="saveAllData()" class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-save mr-2 text-xs"></i>
                        Simpan Semua
                    </button>
                    <button onclick="clearAllRows()" class="inline-flex items-center justify-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-trash mr-2 text-xs"></i>
                        Hapus Semua
                    </button>
                </div>

                <div class="overflow-x-auto custom-scrollbar table-container">
                    <table id="journalTable" class="w-full" style="min-width: 1800px; table-layout: fixed;">
                        <thead class="bg-gray-50 dark:bg-gray-700 sticky top-0 z-10">
                            <tr>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 60px;">
                                    <input type="checkbox" id="selectAll" onchange="toggleSelectAll()" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                </th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 80px;">No</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 140px;">Tgl Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200 border-r border-gray-200 dark:border-gray-600" rowspan="2" style="width: 140px;">Bukti Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" colspan="7">Transaksi</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" colspan="2">Info Balance</th>
                                <th class="px-4 py-4 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200" rowspan="2" style="width: 120px;">Aksi</th>
                            </tr>
                            <tr>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 220px;">Keterangan</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 170px;">Nama Perkiraan</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kd_Perk</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">Customer</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kode</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 170px;">Nama Proyek</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 120px;">Kd Project</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">DEBIT</th>
                                <th class="px-4 py-3 text-center text-xs font-medium text-gray-600 dark:text-gray-300 border-r border-gray-200 dark:border-gray-600" style="width: 140px;">KREDIT</th>
                            </tr>
                        </thead>
                        <tbody id="journalBody" class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700"></tbody>
                    </table>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="flex items-center justify-end gap-2 pt-4 border-t border-gray-200 dark:border-gray-600">
                <button onclick="closeInputModal()" class="inline-flex items-center justify-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-times mr-2 text-xs"></i>
                    Tutup
                </button>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        let rowCounter = 1;
        let journalData = [];

        function openInputModal() {
            document.getElementById('inputModal').classList.remove('hidden');
            loadSavedData();
        }

        function closeInputModal() {
            document.getElementById('inputModal').classList.add('hidden');
        }

        window.onclick = function(event) {
            const modal = document.getElementById('inputModal');
            if (event.target == modal) {
                closeInputModal();
            }
        }

        function addNewRow() {
            const tbody = document.getElementById('journalBody');
            const row = document.createElement('tr');
            row.className = 'journal-row hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200';
            row.setAttribute('data-row-id', rowCounter);

            row.innerHTML = `
                <td class="px-4 py-3 text-center border-r border-gray-200 dark:border-gray-600">
                    <input type="checkbox" class="row-checkbox w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" onchange="updateRowSelection()">
                </td>
                <td class="px-4 py-3 text-center text-sm font-medium text-gray-900 dark:text-white border-r border-gray-200 dark:border-gray-600">${rowCounter}</td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="date" class="journal-input date-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="tanggal_transaksi">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="bukti_transaksi">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="keterangan">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="nama_perkiraan" readonly>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <select class="journal-input account-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kd_perk" onchange="onAccountChange(this)">
                        <option value="">-- Pilih Akun --</option>
                        <?php $__currentLoopData = $chartOfAccounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->kode_akun); ?>" data-nama="<?php echo e($account->nama_akun); ?>"><?php echo e($account->kode_akun); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="customer">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kode">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="nama_proyek" readonly>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <select class="journal-input project-select w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200" data-column="kd_project" onchange="onProjectChange(this)">
                        <option value="">-- Pilih Proyek --</option>
                        <?php $__currentLoopData = $projects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->kode_bantu); ?>" data-nama="<?php echo e($project->nama_proyek); ?>"><?php echo e($project->kode_bantu); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input amount-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-right font-mono transition-all duration-200" data-column="debit" oninput="formatCurrency(this); validateBalance(this)" inputmode="numeric" pattern="[0-9]*[.,]?[0-9]*">
                </td>
                <td class="px-4 py-3 border-r border-gray-200 dark:border-gray-600">
                    <input type="text" class="journal-input amount-input w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-right font-mono transition-all duration-200" data-column="kredit" oninput="formatCurrency(this); validateBalance(this)" inputmode="numeric" pattern="[0-9]*[.,]?[0-9]*">
                </td>
                <td class="px-4 py-3 text-center">
                    <button onclick="deleteRow(${rowCounter})" class="inline-flex items-center justify-center w-10 h-10 text-red-600 hover:text-white hover:bg-red-600 dark:hover:bg-red-500 rounded-lg transition-all duration-200 shadow-sm hover:shadow-md" title="Hapus Baris">
                        <i class="fas fa-trash text-sm"></i>
                    </button>
                </td>
            `;

            tbody.appendChild(row);
            rowCounter++;
        }

        function onAccountChange(selectElement) {
            const row = selectElement.closest('tr');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const namaPerkiraanInput = row.querySelector('input[data-column="nama_perkiraan"]');
            if (selectedOption.value && selectedOption.dataset.nama) {
                namaPerkiraanInput.value = selectedOption.dataset.nama;
            } else {
                namaPerkiraanInput.value = '';
            }
        }

        function onProjectChange(selectElement) {
            const row = selectElement.closest('tr');
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const namaProyekInput = row.querySelector('input[data-column="nama_proyek"]');
            if (selectedOption.value && selectedOption.dataset.nama) {
                namaProyekInput.value = selectedOption.dataset.nama;
            } else {
                namaProyekInput.value = '';
            }
        }

        function toggleSelectAll() {
            const selectAll = document.getElementById('selectAll');
            const checkboxes = document.querySelectorAll('.row-checkbox');
            checkboxes.forEach(cb => { cb.checked = selectAll.checked; });
        }
        function updateRowSelection() {}
        function formatCurrency(input) {
            let val = (input.value || '').replace(/[^0-9]/g, '');
            if (!val) { input.value = ''; return; }
            input.value = parseInt(val, 10).toLocaleString('id-ID');
        }
        function validateBalance(input) {
            const row = input.closest('tr');
            const debitInput = row.querySelector('input[data-column="debit"]');
            const kreditInput = row.querySelector('input[data-column="kredit"]');
            const debitRaw = (debitInput.value || '').replace(/[^0-9]/g, '');
            const kreditRaw = (kreditInput.value || '').replace(/[^0-9]/g, '');
            const debitFilled = debitRaw.length > 0;
            const kreditFilled = kreditRaw.length > 0;
            if (debitFilled && kreditFilled) {
                if (input === debitInput) { kreditInput.value = ''; }
                else { debitInput.value = ''; }
            }
        }
        function deleteRow(id) {
            const row = document.querySelector(`tr[data-row-id='${id}']`);
            if (row) row.remove();
        }

        async function saveAllData() {
            try {
                const rows = document.querySelectorAll('#journalBody tr');
                const entries = [];
                rows.forEach(row => {
                    const inputs = row.querySelectorAll('.journal-input');
                    const entry = {};
                    inputs.forEach(input => {
                        const column = input.getAttribute('data-column');
                        if (column) {
                            let value = input.value;
                            if (input.classList.contains('amount-input')) {
                                value = value.replace(/[^0-9]/g, '');
                            }
                            entry[column] = value;
                        }
                    });
                    const entryId = row.getAttribute('data-entry-id');
                    if (entryId) entry['id'] = entryId;
                    entries.push(entry);
                });

                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({ action: 'save', entries })
                });
                const result = await response.json();
                if (result.success) { generateReport(); }
            } catch (e) {}
        }

        async function generateReport() {
            try {
                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({ action: 'load' })
                });
                const result = await response.json();
                const reportContent = document.getElementById('reportContent');
                let reportHTML = '';
                if (result.entries && result.entries.length > 0) {
                    reportHTML += '<div class="w-full overflow-x-auto custom-scrollbar">';
                    reportHTML += '<table class="min-w-max text-sm journal-report-table">';
                    reportHTML += '<thead class="bg-gray-50 dark:bg-gray-700">';
                    reportHTML += '<tr>' +
                        '<th class="px-4 py-3 text-center align-middle" rowspan="2">No</th>' +
                        '<th class="px-4 py-3 text-left align-middle" rowspan="2">Tgl Transaksi</th>' +
                        '<th class="px-4 py-3 text-left align-middle" rowspan="2">Bukti Transaksi</th>' +
                        '<th class="px-4 py-3 text-center" colspan="7">Transaksi</th>' +
                        '<th class="px-4 py-3 text-center" colspan="2">Balance</th>' +
                        '</tr>';
                    reportHTML += '<tr>' +
                        '<th class="px-4 py-3 text-left">Keterangan</th>' +
                        '<th class="px-4 py-3 text-left">Nama Perkiraan</th>' +
                        '<th class="px-4 py-3 text-left">Kd_Perk</th>' +
                        '<th class="px-4 py-3 text-left">Customer</th>' +
                        '<th class="px-4 py-3 text-left">Kode</th>' +
                        '<th class="px-4 py-3 text-left">Nama Proyek</th>' +
                        '<th class="px-4 py-3 text-left">Kd Project</th>' +
                        '<th class="px-4 py-3 text-right">DEBIT</th>' +
                        '<th class="px-4 py-3 text-right">KREDIT</th>' +
                        '</tr>';
                    reportHTML += '</thead><tbody>';
                    result.entries.forEach((item, index) => {
                        const debit = parseFloat(item.debit || 0);
                        const kredit = parseFloat(item.kredit || 0);
                        reportHTML += '<tr class="border-t">' +
                            `<td class="px-4 py-3 text-center">${index + 1}</td>` +
                            `<td class="px-4 py-3">${item.tanggal_transaksi || ''}</td>` +
                            `<td class="px-4 py-3">${item.bukti_transaksi || ''}</td>` +
                            `<td class="px-4 py-3">${item.keterangan || ''}</td>` +
                            `<td class="px-4 py-3">${item.nama_perkiraan || ''}</td>` +
                            `<td class="px-4 py-3">${item.kd_perk || ''}</td>` +
                            `<td class="px-4 py-3">${item.customer || ''}</td>` +
                            `<td class="px-4 py-3">${item.kode || ''}</td>` +
                            `<td class="px-4 py-3">${item.nama_proyek || ''}</td>` +
                            `<td class="px-4 py-3">${item.kd_project || ''}</td>` +
                            `<td class="px-4 py-3 text-right">${debit.toLocaleString('id-ID')}</td>` +
                            `<td class="px-4 py-3 text-right">${kredit.toLocaleString('id-ID')}</td>` +
                            '</tr>';
                    });
                    reportHTML += '</tbody>';
                    reportHTML += '</table></div>';
                } else {
                    reportHTML = '<div class="p-6 text-center text-gray-500 dark:text-gray-400">Belum ada data jurnal</div>';
                }
                reportContent.innerHTML = reportHTML;
            } catch (e) {
                const reportContent = document.getElementById('reportContent');
                reportContent.innerHTML = '<div class="text-center py-12 text-red-500">Gagal memuat data</div>';
            }
        }

        async function loadSavedData() {
            try {
                const response = await fetch('<?php echo e(route("admin.reports.financial.ajax")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({ action: 'load' })
                });
                const result = await response.json();
                const tbody = document.getElementById('journalBody');
                tbody.innerHTML = '';
                rowCounter = 1;
                if (result.entries && result.entries.length > 0) {
                    result.entries.forEach(entry => {
                        addNewRow();
                        const row = tbody.lastElementChild;
                        row.setAttribute('data-entry-id', entry.id);
                        const selects = row.querySelectorAll('select.journal-input');
                        selects.forEach(select => {
                            const column = select.getAttribute('data-column');
                            if (entry[column]) {
                                select.value = entry[column];
                                if (select.classList.contains('account-select')) onAccountChange(select);
                                if (select.classList.contains('project-select')) onProjectChange(select);
                            }
                        });
                        const inputs = row.querySelectorAll('.journal-input');
                        inputs.forEach(input => {
                            const column = input.getAttribute('data-column');
                            if (entry[column] !== null && entry[column] !== undefined && entry[column] !== '') {
                                if (input.classList.contains('amount-input')) {
                                    input.value = parseFloat(entry[column]).toLocaleString('id-ID');
                                } else {
                                    input.value = entry[column];
                                }
                            }
                        });
                    });
                }
                addNewRow();
            } catch (e) { addNewRow(); }
        }

        document.addEventListener('DOMContentLoaded', function() {
            generateReport();
        });
    </script>

    <style>
        #inputModal { z-index: 9999; }
        .journal-input { transition: all 0.2s; }
        .journal-input:focus { box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2); border-color: rgb(59, 130, 246); }
        .custom-scrollbar { scrollbar-width: auto; scrollbar-color: rgb(156 163 175) rgb(243 244 246); }
        .dark .custom-scrollbar { scrollbar-color: rgb(107 114 128) rgb(31 41 55); }
        .custom-scrollbar::-webkit-scrollbar { width: 16px; height: 16px; background: rgb(243 244 246); }
        .dark .custom-scrollbar::-webkit-scrollbar { background: rgb(31 41 55); }
        .custom-scrollbar::-webkit-scrollbar-track { background: rgb(243 244 246); border-radius: 8px; margin: 4px; }
        .dark .custom-scrollbar::-webkit-scrollbar-track { background: rgb(31 41 55); }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: rgb(156 163 175); border-radius: 8px; border: 3px solid rgb(243 244 246); min-height: 40px; }
        .dark .custom-scrollbar::-webkit-scrollbar-thumb { background: rgb(107 114 128); border: 3px solid rgb(31 41 55); }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: rgb(107 114 128); }
        .dark .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: rgb(75 85 99); }
        #journalTable { table-layout: fixed !important; border-collapse: separate; border-spacing: 0; width: 1800px; min-width: 1800px; }
        #journalTable th, #journalTable td { border-right: 1px solid rgb(229 231 235); padding: 12px 16px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .dark #journalTable th, .dark #journalTable td { border-right: 1px solid rgb(55 65 81); }
        .table-container { width: 100%; overflow-x: auto !important; overflow-y: visible; -webkit-overflow-scrolling: touch; border: 1px solid rgb(229 231 235); border-radius: 8px; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); position: relative; }
        .dark .table-container { border: 1px solid rgb(55 65 81); box-shadow: 0 1px 3px rgba(0, 0, 0, 0.3); }
        .content-wrapper { width: 100% !important; max-width: none !important; box-sizing: border-box; margin-left: 0 !important; overflow: visible !important; }
        .journal-report-table { border-collapse: collapse; border: 1px solid rgb(209 213 219); }
        .journal-report-table th, .journal-report-table td { border: 1px solid rgb(229 231 235); white-space: nowrap; padding: 0.5rem 1rem; }
        .dark .journal-report-table { border-color: rgb(55 65 81); }
        .dark .journal-report-table th, .dark .journal-report-table td { border-color: rgb(55 65 81); }
    </style>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/general-journal.blade.php ENDPATH**/ ?>