

<?php $__env->startSection('title', 'Monitoring Purchases - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $totalPurchases = $purchases->total();
    $approvedCount = $purchases->filter(fn($p) => $p->status === 'approved')->count();
    $pendingCount = $purchases->filter(fn($p) => $p->status === 'pending')->count();
    $totalAmount = $purchases->sum('total_amount');
?>

<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white tracking-tight">Monitoring Pembelian</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1.5">Pantau semua pembelian bahan dan sparepart</p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Pembelian</p>
                    <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e($totalPurchases); ?></p>
                </div>
                <div class="p-3 bg-orange-100 dark:bg-orange-900/40 rounded-xl">
                    <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Disetujui</p>
                    <p class="text-2xl font-bold text-emerald-600 dark:text-emerald-400"><?php echo e($approvedCount); ?></p>
                </div>
                <div class="p-3 bg-emerald-100 dark:bg-emerald-900/40 rounded-xl">
                    <i class="fas fa-check-circle text-emerald-600 dark:text-emerald-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Menunggu</p>
                    <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400"><?php echo e($pendingCount); ?></p>
                </div>
                <div class="p-3 bg-yellow-100 dark:bg-yellow-900/40 rounded-xl">
                    <i class="fas fa-clock text-yellow-600 dark:text-yellow-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Nilai</p>
                    <p class="text-lg font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($totalAmount, 0, ',', '.')); ?></p>
                </div>
                <div class="p-3 bg-indigo-100 dark:bg-indigo-900/40 rounded-xl">
                    <i class="fas fa-dollar-sign text-indigo-600 dark:text-indigo-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Purchases Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden shadow-sm">
        <div class="px-6 py-4 bg-gradient-to-r from-orange-50 to-amber-50 dark:from-gray-700 dark:to-gray-700 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                    <div class="w-10 h-10 bg-orange-100 dark:bg-orange-900/30 rounded-lg flex items-center justify-center">
                        <i class="fas fa-shopping-cart text-orange-600 dark:text-orange-400"></i>
                    </div>
                    Data Pembelian
                </h2>
                <span class="px-3 py-1.5 bg-orange-600 text-white text-xs font-bold rounded-full"><?php echo e($totalPurchases); ?> pembelian</span>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full table-auto">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tanggal</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Kode</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Supplier</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tipe</th>
                        <th class="px-6 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Total</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900 dark:text-white"><?php echo e($purchase->purchase_date ? $purchase->purchase_date->format('d M Y') : '-'); ?></div>
                            <?php if($purchase->purchase_date): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e($purchase->purchase_date->diffForHumans()); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-sm font-semibold bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-white">
                                <?php echo e($purchase->purchase_code ?? '#' . $purchase->id); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/40 rounded-full flex items-center justify-center">
                                    <i class="fas fa-building text-blue-600 dark:text-blue-400 text-xs"></i>
                                </div>
                                <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e(Str::limit($purchase->supplier_name ?? '-', 25)); ?></div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full border
                                <?php if(strtolower($purchase->purchase_type ?? '') === 'material' || strtolower($purchase->purchase_type ?? '') === 'bahan'): ?>
                                    bg-emerald-100 text-emerald-700 border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                <?php elseif(strtolower($purchase->purchase_type ?? '') === 'sparepart' || strtolower($purchase->purchase_type ?? '') === 'spare part'): ?>
                                    bg-blue-100 text-blue-700 border-blue-300 dark:bg-blue-900/30 dark:text-blue-300
                                <?php else: ?>
                                    bg-gray-100 text-gray-700 border-gray-300 dark:bg-gray-700 dark:text-gray-300
                                <?php endif; ?>">
                                <?php echo e(ucfirst($purchase->purchase_type ?? '-')); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <span class="text-sm font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?></span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <span class="inline-flex items-center px-2.5 py-1 text-xs font-semibold rounded-full
                                <?php if($purchase->status === 'approved'): ?> bg-emerald-100 text-emerald-700 border border-emerald-300 dark:bg-emerald-900/30 dark:text-emerald-300
                                <?php elseif($purchase->status === 'pending'): ?> bg-yellow-100 text-yellow-700 border border-yellow-300 dark:bg-yellow-900/30 dark:text-yellow-300
                                <?php elseif($purchase->status === 'rejected'): ?> bg-red-100 text-red-700 border border-red-300 dark:bg-red-900/30 dark:text-red-300
                                <?php else: ?> bg-gray-100 text-gray-700 border border-gray-300 dark:bg-gray-700 dark:text-gray-300 <?php endif; ?>">
                                <?php echo e(ucfirst($purchase->status ?? '-')); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-4">
                                <i class="fas fa-inbox text-3xl text-gray-400 dark:text-gray-500"></i>
                            </div>
                            <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-1">Tidak Ada Data Pembelian</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Belum ada pembelian yang tercatat</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($purchases->hasPages()): ?>
        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700/30">
            <?php echo e($purchases->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/monitoring/purchases.blade.php ENDPATH**/ ?>