

<?php $__env->startSection('title', 'Clear Cache'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Clear Cache</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Membersihkan semua cache aplikasi (untuk cPanel tanpa SSH)
                    </p>
                </div>
            </div>
        </div>

        <!-- Results Card -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-white">
                    <i class="fas fa-broom mr-2 text-green-600"></i>
                    Hasil Clear Cache
                </h3>
            </div>

            <div class="p-6">
                <?php if(isset($hasError) && $hasError): ?>
                    <!-- Error Alert -->
                    <div class="mb-6 p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-circle text-red-600 dark:text-red-400 text-xl mr-3 mt-0.5"></i>
                            <div class="flex-1">
                                <h4 class="text-red-800 dark:text-red-200 font-semibold mb-2">Terjadi Beberapa Error</h4>
                                <ul class="list-disc list-inside text-sm text-red-700 dark:text-red-300 space-y-1">
                                    <?php $__currentLoopData = $errors ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(isset($results) && count($results) > 0): ?>
                    <!-- Success Results -->
                    <div class="mb-6">
                        <h4 class="text-green-800 dark:text-green-200 font-semibold mb-3 flex items-center">
                            <i class="fas fa-check-circle text-green-600 dark:text-green-400 mr-2"></i>
                            Cache Berhasil Dihapus:
                        </h4>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center p-3 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg">
                                    <i class="fas fa-check text-green-600 dark:text-green-400 mr-3"></i>
                                    <span class="text-sm text-green-800 dark:text-green-200"><?php echo e($result); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if((!isset($results) || count($results) == 0) && (!isset($errors) || count($errors) == 0)): ?>
                    <!-- No Results -->
                    <div class="text-center py-8">
                        <i class="fas fa-info-circle text-gray-400 dark:text-gray-500 text-4xl mb-4"></i>
                        <p class="text-gray-500 dark:text-gray-400">Tidak ada hasil untuk ditampilkan</p>
                    </div>
                <?php endif; ?>

                <!-- Action Buttons -->
                <div class="mt-6 flex items-center justify-between pt-6 border-t border-gray-200 dark:border-gray-600">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" 
                       class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Kembali ke Dashboard
                    </a>
                    <a href="<?php echo e(route('admin.clear-cache')); ?>" 
                       class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-redo mr-2"></i>
                        Clear Cache Lagi
                    </a>
                </div>
            </div>
        </div>

        <!-- Info Card -->
        <div class="mt-6 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800 p-6">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-600 dark:text-blue-400 text-xl mr-3 mt-0.5"></i>
                <div class="flex-1">
                    <h4 class="text-blue-800 dark:text-blue-200 font-semibold mb-2">Informasi</h4>
                    <ul class="text-sm text-blue-700 dark:text-blue-300 space-y-1 list-disc list-inside">
                        <li>Fitur ini sangat berguna untuk hosting cPanel yang tidak memiliki akses SSH/Terminal</li>
                        <li>Semua operasi dilakukan melalui web interface</li>
                        <li>Disarankan untuk clear cache setelah mengupload file baru atau melakukan perubahan kode</li>
                        <li>Cache yang dibersihkan: Application Cache, Config Cache, Route Cache, View Cache, dan Compiled Classes</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/clear-cache.blade.php ENDPATH**/ ?>