<?php
    // Default values jika tidak ada heroes
    $defaultTitle = 'Solusi Mesin Teknologi Terdepan';
    $defaultSubtitle = 'Untuk Semua Kebutuhan Bisnis & Industri Anda';
    $defaultDescription = 'Menyediakan berbagai mesin berkualitas tinggi untuk meningkatkan produktivitas bisnis Anda';
    
    // Gunakan data heroes yang sudah dikirim dari controller, atau ambil dari database jika tidak ada
    if (!isset($heroes)) {
        $heroes = \App\Models\Hero::where('is_active', true)
            ->orderBy('order')
            ->orderBy('created_at', 'desc')
            ->get();
    }
?>

<?php if(isset($heroes) && $heroes->count() > 0): ?>
    <div class="relative w-full max-w-[1200px] mx-auto overflow-hidden group" 
         x-data="heroSlider(<?php echo e($heroes->count()); ?>)"
         x-cloak
         @mouseenter="pauseAutoPlay()"
         @mouseleave="resumeAutoPlay()">
        
        <!-- Slides Container -->
        <div class="relative h-[400px] overflow-hidden">
            <?php $__currentLoopData = $heroes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $hero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $title = $hero->title ?? $defaultTitle;
                    $subtitle = $hero->subtitle ?? $defaultSubtitle;
                    $description = $hero->description ?? $defaultDescription;
                    $imageUrl = asset('uploads/' . $hero->image);
                ?>
                
                <!-- Slide -->
                <div 
                    class="absolute inset-0 transition-opacity duration-1000 ease-in-out"
                    :class="{ 'opacity-100 z-10': currentSlide === <?php echo e($index); ?>, 'opacity-0 z-0': currentSlide !== <?php echo e($index); ?> }"
                    x-show="currentSlide === <?php echo e($index); ?>"
                    x-transition:enter="transition ease-out duration-1000"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="transition ease-in duration-1000"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0">
                    
                    <!-- Background Image -->
                    <div 
                        class="absolute inset-0 w-full h-full bg-cover bg-center bg-no-repeat"
                        style="background-image: url('<?php echo e($imageUrl); ?>'); background-size: cover; background-position: center;">
                        <!-- Overlay untuk readability -->
                        <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/40 to-black/20"></div>
                    </div>
                    
                    <!-- Content Overlay -->
                    <div class="relative h-full flex items-center z-10">
                        <div class="w-full max-w-[1200px] mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="max-w-2xl text-white text-center mx-auto">
                                <!-- Title -->
                                <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-3 sm:mb-4 leading-tight drop-shadow-lg">
                                    <?php echo e($title); ?>

                                </h1>
                                
                                <!-- Subtitle -->
                                <h2 class="text-lg sm:text-xl md:text-2xl lg:text-3xl font-semibold mb-3 sm:mb-4 text-blue-200 drop-shadow-md">
                                    <?php echo e($subtitle); ?>

                                </h2>
                                
                                <!-- Description -->
                                <p class="text-sm sm:text-base md:text-lg text-gray-100 mb-6 sm:mb-8 leading-relaxed drop-shadow-md max-w-xl mx-auto">
                                    <?php echo e($description); ?>

                                </p>
                                
                                <!-- Call to Action Button (Optional) -->
                                <a href="<?php echo e(route('all')); ?>" 
                                   class="inline-flex items-center gap-2 px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                                    <span>Lihat Produk</span>
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <!-- Navigation Arrows - Gaya Kotak dengan Hover Biru -->
        <?php if($heroes->count() > 1): ?>
            <!-- Previous Button -->
            <button 
                @click="previousSlide()"
                class="absolute left-4 top-1/2 -translate-y-1/2 z-20 bg-black/50 text-white p-3 text-lg hover:bg-blue-500 transition-all duration-300 opacity-0 group-hover:opacity-100"
                aria-label="Slide sebelumnya">
                <i class="fas fa-chevron-left"></i>
            </button>
            
            <!-- Next Button -->
            <button 
                @click="nextSlide()"
                class="absolute right-4 top-1/2 -translate-y-1/2 z-20 bg-black/50 text-white p-3 text-lg hover:bg-blue-500 transition-all duration-300 opacity-0 group-hover:opacity-100"
                aria-label="Slide berikutnya">
                <i class="fas fa-chevron-right"></i>
            </button>
        <?php endif; ?>
        
        <!-- Dots/Indicators -->
        <?php if($heroes->count() > 1): ?>
            <div class="absolute bottom-4 left-1/2 -translate-x-1/2 z-20 flex gap-2">
                <?php $__currentLoopData = $heroes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $hero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        @click="goToSlide(<?php echo e($index); ?>)"
                        class="w-2 h-2 sm:w-3 sm:h-3 rounded-full transition-all duration-300"
                        :class="currentSlide === <?php echo e($index); ?> ? 'bg-white w-6 sm:w-8' : 'bg-white/50 hover:bg-white/75'"
                        :aria-label="'Go to slide <?php echo e($index + 1); ?>'">
                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Alpine.js Component -->
    <script>
        function heroSlider(totalSlides) {
            return {
                currentSlide: 0,
                autoPlayInterval: null,
                autoPlayDelay: 5000, // 5 seconds
                
                init() {
                    this.startAutoPlay();
                    
                    // Touch/swipe support untuk mobile
                    let touchStartX = 0;
                    let touchEndX = 0;
                    
                    const slider = this.$el;
                    
                    slider.addEventListener('touchstart', (e) => {
                        touchStartX = e.changedTouches[0].screenX;
                    });
                    
                    slider.addEventListener('touchend', (e) => {
                        touchEndX = e.changedTouches[0].screenX;
                        this.handleSwipe();
                    });
                },
                
                nextSlide() {
                    this.currentSlide = (this.currentSlide + 1) % totalSlides;
                    this.resetAutoPlay();
                },
                
                previousSlide() {
                    this.currentSlide = (this.currentSlide - 1 + totalSlides) % totalSlides;
                    this.resetAutoPlay();
                },
                
                goToSlide(index) {
                    this.currentSlide = index;
                    this.resetAutoPlay();
                },
                
                startAutoPlay() {
                    this.autoPlayInterval = setInterval(() => {
                        this.nextSlide();
                    }, this.autoPlayDelay);
                },
                
                pauseAutoPlay() {
                    if (this.autoPlayInterval) {
                        clearInterval(this.autoPlayInterval);
                        this.autoPlayInterval = null;
                    }
                },
                
                resumeAutoPlay() {
                    if (!this.autoPlayInterval) {
                        this.startAutoPlay();
                    }
                },
                
                resetAutoPlay() {
                    this.pauseAutoPlay();
                    this.startAutoPlay();
                },
                
                handleSwipe() {
                    const swipeThreshold = 50;
                    const diff = touchStartX - touchEndX;
                    
                    if (Math.abs(diff) > swipeThreshold) {
                        if (diff > 0) {
                            // Swipe left - next slide
                            this.nextSlide();
                        } else {
                            // Swipe right - previous slide
                            this.previousSlide();
                        }
                    }
                }
            }
        }
    </script>
<?php else: ?>
    <!-- Fallback jika tidak ada heroes -->
    <div class="relative w-full max-w-[1200px] mx-auto h-[400px] overflow-hidden">
        <div class="absolute inset-0 w-full h-full bg-cover bg-center bg-no-repeat"
             style="background-image: url('<?php echo e(asset('images/hero/hero1.png')); ?>'); background-size: cover; background-position: center;">
            <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/40 to-black/20"></div>
        </div>
        <div class="relative h-full flex items-center z-10">
            <div class="w-full max-w-[1200px] mx-auto px-4 sm:px-6 lg:px-8">
                <div class="max-w-2xl text-white text-center mx-auto">
                    <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-3 sm:mb-4 leading-tight drop-shadow-lg">
                        <?php echo e($defaultTitle); ?>

                    </h1>
                    <h2 class="text-lg sm:text-xl md:text-2xl lg:text-3xl font-semibold mb-3 sm:mb-4 text-blue-200 drop-shadow-md">
                        <?php echo e($defaultSubtitle); ?>

                    </h2>
                    <p class="text-sm sm:text-base md:text-lg text-gray-100 mb-6 sm:mb-8 leading-relaxed drop-shadow-md max-w-xl mx-auto">
                        <?php echo e($defaultDescription); ?>

                    </p>
                    <a href="<?php echo e(route('all')); ?>" 
                       class="inline-flex items-center gap-2 px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        <span>Lihat Produk</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/partials/hero.blade.php ENDPATH**/ ?>