

<?php $__env->startSection('title', 'Performance Analytics - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Performance Analytics</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Analisis performa produksi, teknisi, dan penawaran
                </p>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="<?php echo e(route('supervisor.analytics.index')); ?>" class="flex flex-wrap items-center gap-4">
            <div class="flex-1 min-w-[150px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Periode</label>
                <select name="period" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                    <option value="month" <?php echo e($period === 'month' ? 'selected' : ''); ?>>Bulan Ini</option>
                    <option value="quarter" <?php echo e($period === 'quarter' ? 'selected' : ''); ?>>Kuartal Ini</option>
                    <option value="year" <?php echo e($period === 'year' ? 'selected' : ''); ?>>Tahun Ini</option>
                </select>
            </div>
            <div class="flex-1 min-w-[150px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Tanggal Mulai</label>
                <input type="date" name="start_date" value="<?php echo e($startDate); ?>" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
            </div>
            <div class="flex-1 min-w-[150px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Tanggal Akhir</label>
                <input type="date" name="end_date" value="<?php echo e($endDate); ?>" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
            </div>
            <div class="flex items-end">
                <button type="submit" 
                    class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-filter mr-2"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Summary Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Produksi</p>
                    <h2 class="text-xl font-bold text-indigo-600 dark:text-indigo-400"><?php echo e(number_format($summaryStats['total_productions'], 0, ',', '.')); ?></h2>
                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">
                        Selesai: <?php echo e(number_format($summaryStats['completed_productions'], 0, ',', '.')); ?>

                    </p>
                </div>
                <div class="p-2.5 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-industry text-indigo-600 dark:text-indigo-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Biaya Produksi</p>
                    <h2 class="text-xl font-bold text-green-600 dark:text-green-400">Rp <?php echo e(number_format($summaryStats['total_production_cost'], 0, ',', '.')); ?></h2>
                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">
                        Rata-rata: <?php echo e($summaryStats['total_productions'] > 0 ? 'Rp ' . number_format($summaryStats['total_production_cost'] / $summaryStats['total_productions'], 0, ',', '.') : 'Rp 0'); ?>

                    </p>
                </div>
                <div class="p-2.5 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-money-bill-wave text-green-600 dark:text-green-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Rata-rata Waktu</p>
                    <h2 class="text-xl font-bold text-blue-600 dark:text-blue-400"><?php echo e(number_format($summaryStats['avg_production_time'], 1)); ?> hari</h2>
                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">
                        Per produksi
                    </p>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-clock text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Penawaran</p>
                    <h2 class="text-xl font-bold text-purple-600 dark:text-purple-400"><?php echo e(number_format($summaryStats['total_quotations'], 0, ',', '.')); ?></h2>
                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">
                        Disetujui: <?php echo e(number_format($summaryStats['approved_quotations'], 0, ',', '.')); ?>

                    </p>
                </div>
                <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-handshake text-purple-600 dark:text-purple-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-4">
        <!-- Production Trend Chart -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white mb-4">Trend Produksi (12 Bulan Terakhir)</h3>
            <div style="position: relative; height: 250px;">
                <canvas id="productionTrendChart"></canvas>
            </div>
        </div>

        <!-- Production Status Distribution -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white mb-4">Distribusi Status Produksi</h3>
            <div style="position: relative; height: 250px;">
                <canvas id="productionStatusChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Quotation Analytics -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 mb-4">
        <!-- Quotation Status Chart -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white mb-4">Status Penawaran</h3>
            <div style="position: relative; height: 250px;">
                <canvas id="quotationStatusChart"></canvas>
            </div>
        </div>

        <!-- Approval Metrics -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white mb-4">Metrik Persetujuan</h3>
            <div class="space-y-4">
                <div class="flex items-center justify-between p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400">Pending Planning</p>
                        <p class="text-lg font-bold text-blue-600 dark:text-blue-400"><?php echo e(number_format($summaryStats['pending_planning'], 0, ',', '.')); ?></p>
                    </div>
                    <i class="fas fa-clock text-blue-600 dark:text-blue-400 text-2xl"></i>
                </div>
                <div class="flex items-center justify-between p-3 bg-purple-50 dark:bg-purple-900/20 rounded-lg">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400">Pending Completion</p>
                        <p class="text-lg font-bold text-purple-600 dark:text-purple-400"><?php echo e(number_format($summaryStats['pending_completion'], 0, ',', '.')); ?></p>
                    </div>
                    <i class="fas fa-check-circle text-purple-600 dark:text-purple-400 text-2xl"></i>
                </div>
                <div class="flex items-center justify-between p-3 bg-green-50 dark:bg-green-900/20 rounded-lg">
                    <div>
                        <p class="text-xs text-gray-600 dark:text-gray-400">Rata-rata Waktu Approval</p>
                        <p class="text-lg font-bold text-green-600 dark:text-green-400"><?php echo e(number_format($summaryStats['avg_approval_time'], 1)); ?> jam</p>
                    </div>
                    <i class="fas fa-hourglass-half text-green-600 dark:text-green-400 text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Teknisi Performance Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
            <h3 class="text-base font-semibold text-gray-800 dark:text-white">Top 10 Performa Teknisi</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Rank</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Nama Teknisi</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total Produksi</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Selesai</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total Biaya</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Rata-rata Biaya</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $teknisiPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex items-center justify-center w-8 h-8 rounded-full 
                                    <?php if($index === 0): ?> bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300
                                    <?php elseif($index === 1): ?> bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300
                                    <?php elseif($index === 2): ?> bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-300
                                    <?php else: ?> bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300
                                    <?php endif; ?> font-bold text-sm">
                                    <?php echo e($index + 1); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo e($teknisi['name']); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-900 dark:text-white">
                                <?php echo e(number_format($teknisi['total_productions'], 0, ',', '.')); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-900 dark:text-white">
                                <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-green-100 text-green-700 dark:bg-green-900/30 dark:text-green-300">
                                    <?php echo e(number_format($teknisi['completed_productions'], 0, ',', '.')); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-semibold text-gray-900 dark:text-white">
                                Rp <?php echo e(number_format($teknisi['total_cost'], 0, ',', '.')); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-900 dark:text-white">
                                Rp <?php echo e(number_format($teknisi['avg_cost_per_production'], 0, ',', '.')); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                        <i class="fas fa-users text-3xl text-gray-400 dark:text-gray-500"></i>
                                    </div>
                                    <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data teknisi</p>
                                    <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada data performa teknisi dalam periode ini.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
(function() {
    // Prevent multiple initializations
    if (window.analyticsChartsInitialized) {
        return;
    }
    window.analyticsChartsInitialized = true;

    document.addEventListener('DOMContentLoaded', function() {
        const isDark = document.documentElement.classList.contains('dark');
        const textColor = isDark ? '#e5e7eb' : '#374151';
        const gridColor = isDark ? '#374151' : '#e5e7eb';

        // Production Trend Chart
        const productionTrendCtx = document.getElementById('productionTrendChart');
        if (productionTrendCtx && !productionTrendCtx.chart) {
            const productionTrendData = <?php echo json_encode($productionTrend, 15, 512) ?>;
            productionTrendCtx.chart = new Chart(productionTrendCtx, {
            type: 'line',
            data: {
                labels: productionTrendData.map(item => {
                    const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
                    return monthNames[item.month - 1] + ' ' + item.year;
                }),
                datasets: [{
                    label: 'Jumlah Produksi',
                    data: productionTrendData.map(item => item.count),
                    borderColor: '#3b82f6',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    tension: 0.4,
                    fill: true
                }, {
                    label: 'Total Biaya (Juta)',
                    data: productionTrendData.map(item => (item.total_cost / 1000000).toFixed(1)),
                    borderColor: '#10b981',
                    backgroundColor: 'rgba(16, 185, 129, 0.1)',
                    tension: 0.4,
                    fill: true,
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        labels: { color: textColor }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { color: textColor },
                        grid: { color: gridColor }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        ticks: { color: textColor },
                        grid: { drawOnChartArea: false }
                    },
                    x: {
                        ticks: { color: textColor },
                        grid: { color: gridColor }
                    }
                }
            }
            });
        }

        // Production Status Chart
        const productionStatusCtx = document.getElementById('productionStatusChart');
        if (productionStatusCtx && !productionStatusCtx.chart) {
            const productionStatusData = <?php echo json_encode($productionsByStatus, 15, 512) ?>;
            productionStatusCtx.chart = new Chart(productionStatusCtx, {
            type: 'doughnut',
            data: {
                labels: Object.keys(productionStatusData).map(key => {
                    return key.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase());
                }),
                datasets: [{
                    data: Object.values(productionStatusData),
                    backgroundColor: [
                        '#10b981', // selesai
                        '#3b82f6', // dalam_proses
                        '#f59e0b', // menunggu
                        '#ef4444'  // dibatalkan
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: { color: textColor }
                    }
                }
            }
            });
        }

        // Quotation Status Chart
        const quotationStatusCtx = document.getElementById('quotationStatusChart');
        if (quotationStatusCtx && !quotationStatusCtx.chart) {
            const quotationStatusData = <?php echo json_encode($quotationStatusData, 15, 512) ?>;
            quotationStatusCtx.chart = new Chart(quotationStatusCtx, {
            type: 'bar',
            data: {
                labels: quotationStatusData.map(item => {
                    return item.status.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase());
                }),
                datasets: [{
                    label: 'Jumlah Penawaran',
                    data: quotationStatusData.map(item => item.count),
                    backgroundColor: [
                        '#3b82f6', // supervisor_review
                        '#10b981', // approved
                        '#ef4444', // rejected
                        '#f59e0b'  // lainnya
                    ]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { color: textColor },
                        grid: { color: gridColor }
                    },
                    x: {
                        ticks: { color: textColor },
                        grid: { color: gridColor }
                    }
                }
            }
            });
        }

        // Listen for theme changes
        document.addEventListener('theme:toggle', function(e) {
            location.reload(); // Reload to update chart colors
        });
    });
})();
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/analytics/index.blade.php ENDPATH**/ ?>