

<?php $__env->startSection('title', 'Kalender - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Kalender & Agenda</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Tracking deadline produksi, penawaran, dan jadwal penting
                </p>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Event</p>
                    <h2 class="text-xl font-bold text-indigo-600 dark:text-indigo-400"><?php echo e(number_format($stats['total_events'], 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-calendar-alt text-indigo-600 dark:text-indigo-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Event Produksi</p>
                    <h2 class="text-xl font-bold text-blue-600 dark:text-blue-400"><?php echo e(number_format($stats['production_events'], 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Event Penawaran</p>
                    <h2 class="text-xl font-bold text-purple-600 dark:text-purple-400"><?php echo e(number_format($stats['quotation_events'], 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-handshake text-purple-600 dark:text-purple-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Terlambat</p>
                    <h2 class="text-xl font-bold text-red-600 dark:text-red-400"><?php echo e(number_format($stats['overdue_count'], 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-red-100 dark:bg-red-900/40 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-red-600 dark:text-red-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="<?php echo e(route('supervisor.calendar.index')); ?>" class="flex flex-wrap items-center gap-4">
            <div class="flex-1 min-w-[200px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Periode Mulai</label>
                <input type="date" name="start" value="<?php echo e($startDate); ?>" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
            </div>
            <div class="flex-1 min-w-[200px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Periode Akhir</label>
                <input type="date" name="end" value="<?php echo e($endDate); ?>" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
            </div>
            <div class="flex-1 min-w-[150px]">
                <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Tipe Event</label>
                <select name="type" 
                    class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm">
                    <option value="all" <?php echo e($type === 'all' ? 'selected' : ''); ?>>Semua</option>
                    <option value="production" <?php echo e($type === 'production' ? 'selected' : ''); ?>>Produksi</option>
                    <option value="quotation" <?php echo e($type === 'quotation' ? 'selected' : ''); ?>>Penawaran</option>
                    <option value="order" <?php echo e($type === 'order' ? 'selected' : ''); ?>>Order</option>
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" 
                    class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                    <i class="fas fa-filter mr-2"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Calendar -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 overflow-hidden">
        <div id="calendar"></div>
    </div>

    <!-- Legend -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
        <h3 class="text-sm font-semibold text-gray-800 dark:text-white mb-3">Legenda</h3>
        <div class="flex flex-wrap gap-4">
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 rounded bg-green-500"></div>
                <span class="text-xs text-gray-600 dark:text-gray-400">Produksi Selesai</span>
            </div>
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 rounded bg-blue-500"></div>
                <span class="text-xs text-gray-600 dark:text-gray-400">Produksi Dalam Proses</span>
            </div>
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 rounded bg-yellow-500"></div>
                <span class="text-xs text-gray-600 dark:text-gray-400">Produksi Menunggu</span>
            </div>
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 rounded bg-purple-500"></div>
                <span class="text-xs text-gray-600 dark:text-gray-400">Mulai Produksi</span>
            </div>
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 rounded bg-red-500"></div>
                <span class="text-xs text-gray-600 dark:text-gray-400">Pending/Overdue</span>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css' rel='stylesheet' />
<style>
    .fc {
        font-family: inherit;
    }
    .fc-event {
        cursor: pointer;
    }
    .fc-daygrid-event {
        white-space: normal;
    }
    .fc-toolbar-title {
        font-size: 1.5rem;
        font-weight: 600;
    }
    .fc-button {
        background-color: #3b82f6;
        border-color: #3b82f6;
    }
    .fc-button:hover {
        background-color: #2563eb;
        border-color: #2563eb;
    }
    .fc-button-active {
        background-color: #1d4ed8;
        border-color: #1d4ed8;
    }
    .dark .fc-theme-standard td, .dark .fc-theme-standard th {
        border-color: #374151;
    }
    .dark .fc-theme-standard .fc-scrollgrid {
        border-color: #374151;
    }
    .dark .fc-daygrid-day {
        background-color: #1f2937;
    }
    .dark .fc-col-header-cell {
        background-color: #111827;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js'></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('calendar');
    const events = <?php echo json_encode($events, 15, 512) ?>;

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'id',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
        },
        events: events.map(event => ({
            id: event.id,
            title: event.title,
            start: event.start,
            end: event.end,
            backgroundColor: event.color,
            borderColor: event.color,
            textColor: '#ffffff',
            url: event.url,
            extendedProps: {
                type: event.type,
                description: event.description,
                status: event.status
            }
        })),
        eventClick: function(info) {
            if (info.event.url) {
                window.location.href = info.event.url;
                return false;
            }
        },
        eventDidMount: function(info) {
            // Add tooltip
            if (info.event.extendedProps.description) {
                info.el.setAttribute('title', info.event.extendedProps.description);
            }
        },
        height: 'auto',
        contentHeight: 600
    });

    calendar.render();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/calendar/index.blade.php ENDPATH**/ ?>