<!-- Stats Cards Row 1 - Key Metrics -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6 w-full">
    <!-- Card 1: Pending Planning Approvals -->
    <div class="bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-yellow-100 text-sm font-medium">Pending Planning</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-edit text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['pending_planning_approvals'] ?? 0); ?></h3>
            <p class="text-yellow-100 text-sm">Planning menunggu persetujuan</p>
        </div>
    </div>

    <!-- Card 2: Pending Completion Approvals -->
    <div class="bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-orange-100 text-sm font-medium">Pending Completion</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-check-double text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['pending_completion_approvals'] ?? 0); ?></h3>
            <p class="text-orange-100 text-sm">Penyelesaian menunggu persetujuan</p>
        </div>
    </div>

    <!-- Card 3: Pending Purchase Approvals -->
    <div class="bg-gradient-to-br from-red-500 to-red-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-red-100 text-sm font-medium">Pending Purchase</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-shopping-cart text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['pending_purchase_approvals'] ?? 0); ?></h3>
            <p class="text-red-100 text-sm">Pembelian menunggu persetujuan</p>
        </div>
    </div>

    <!-- Card 4: Stock Alert -->
    <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -mr-16 -mt-16"></div>
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <p class="text-purple-100 text-sm font-medium">Stock Alert</p>
                <div class="bg-white/20 rounded-lg p-2.5">
                    <i class="fas fa-exclamation-triangle text-white text-lg"></i>
                </div>
            </div>
            <h3 class="text-3xl font-bold mb-2"><?php echo e($stats['total_low_stock'] ?? 0); ?></h3>
            <div class="flex items-center gap-3 text-sm">
                <span class="text-purple-100">Materials: <?php echo e($stats['low_stock_materials'] ?? 0); ?></span>
                <span class="text-purple-200">•</span>
                <span class="text-purple-100">Spareparts: <?php echo e($stats['low_stock_spareparts'] ?? 0); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Additional Stats Cards Row 2 -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-6 mb-6">
    <!-- Card 5: Active Productions Today -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Produksi Aktif Hari Ini</p>
            <div class="bg-blue-100 dark:bg-blue-900/30 rounded-lg p-2.5">
                <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['active_productions_today'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Sedang dalam proses pengerjaan
        </p>
    </div>

    <!-- Card 6: Overdue Productions -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Produksi Terlambat</p>
            <div class="bg-red-100 dark:bg-red-900/30 rounded-lg p-2.5">
                <i class="fas fa-clock text-red-600 dark:text-red-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['overdue_productions'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Melewati estimasi selesai
        </p>
    </div>

    <!-- Card 7: Monthly Sales -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Penjualan Bulan Ini</p>
            <div class="bg-green-100 dark:bg-green-900/30 rounded-lg p-2.5">
                <i class="fas fa-dollar-sign text-green-600 dark:text-green-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Rp <?php echo e(number_format($stats['monthly_sales'] ?? 0, 0, ',', '.')); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Total penjualan bulan ini
        </p>
    </div>

    <!-- Card 8: Pending Quotations -->
    <div class="bg-white dark:bg-gray-800 rounded-xl p-6 border border-gray-100 dark:border-gray-700">
        <div class="flex items-center justify-between mb-4">
            <p class="text-gray-600 dark:text-gray-400 text-sm font-medium">Penawaran Perlu Review</p>
            <div class="bg-amber-100 dark:bg-amber-900/30 rounded-lg p-2.5">
                <i class="fas fa-handshake text-amber-600 dark:text-amber-400 text-lg"></i>
            </div>
        </div>
        <h3 class="text-3xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($stats['pending_quotations'] ?? 0); ?></h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">
            Penawaran menunggu review
        </p>
    </div>
</div>

<!-- Alert Card - Pending Approvals Overdue -->
<?php if(($stats['pending_planning_overdue'] ?? 0) > 0): ?>
<div class="mb-6">
    <div class="bg-gradient-to-r from-amber-500 to-orange-500 rounded-xl p-6 text-white relative overflow-hidden">
        <div class="absolute top-0 right-0 w-40 h-40 bg-white/10 rounded-full -mr-20 -mt-20"></div>
        <div class="absolute bottom-0 left-0 w-32 h-32 bg-white/5 rounded-full -ml-16 -mb-16"></div>
        <div class="relative z-10 flex items-center justify-between">
            <div class="flex-1">
                <div class="flex items-center mb-3">
                    <div class="bg-white/20 rounded-lg p-2.5 mr-3">
                        <i class="fas fa-exclamation-triangle text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold mb-1">Planning Menunggu Lebih dari 24 Jam</h3>
                        <p class="text-amber-100 text-sm">Ada planning yang sudah menunggu lebih dari 24 jam, perlu segera ditinjau</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div>
                        <p class="text-3xl font-bold mb-1"><?php echo e($stats['pending_planning_overdue'] ?? 0); ?></p>
                        <p class="text-amber-100 text-xs">Planning tertunda</p>
                    </div>
                    <a href="<?php echo e(route('supervisor.productions.index')); ?>" 
                       class="inline-flex items-center px-4 py-2 bg-white/20 hover:bg-white/30 rounded-lg font-medium text-sm transition-colors backdrop-blur-sm">
                        <span>Lihat Detail</span>
                        <i class="fas fa-arrow-right ml-2 text-xs"></i>
                    </a>
                </div>
            </div>
            <div class="hidden lg:block ml-6">
                <div class="bg-white/20 rounded-full p-6 backdrop-blur-sm">
                    <i class="fas fa-hourglass-half text-white text-4xl"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/partials/dashboard-stats-cards.blade.php ENDPATH**/ ?>