<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nota Pemesanan #<?php echo e($order->id); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }
        
        .content-container {
            max-width: 180mm;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .company-address {
            font-size: 11px;
            color: #666;
            margin-bottom: 3px;
        }
        
        .invoice-title {
            font-size: 18px;
            font-weight: bold;
            margin: 15px 0 10px 0;
        }
        
        .invoice-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        
        .invoice-info-left, .invoice-info-right {
            width: 48%;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 5px;
        }
        
        .info-label {
            font-weight: bold;
            width: 120px;
        }
        
        .info-value {
            flex: 1;
        }
        
        .product-section {
            margin: 20px 0;
        }
        
        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        
        .product-table th,
        .product-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        
        .product-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        
        .product-table .text-right {
            text-align: right;
        }
        
        .total-section {
            margin-top: 20px;
            text-align: right;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            padding: 5px 0;
        }
        
        .total-label {
            font-weight: bold;
            width: 150px;
        }
        
        .total-value {
            width: 100px;
            text-align: right;
        }
        
        .grand-total {
            border-top: 2px solid #000;
            padding-top: 10px;
            font-size: 14px;
            font-weight: bold;
        }
        
        .payment-info {
            margin: 20px 0;
            padding: 15px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
        }
        
        .terms {
            margin-top: 30px;
            font-size: 10px;
            color: #666;
        }
        
        .signature-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            height: 40px;
            margin-bottom: 5px;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10mm;
                font-size: 11px;
            }
            
            .content-container {
                max-width: 100%;
                margin: 0 auto;
                background: #fff;
                padding: 0;
                position: static;
                left: auto;
                transform: none;
            }
            
            body {
                background: #fff;
                padding: 10mm;
            }
            
            .header {
                margin-bottom: 15px;
                padding-bottom: 10px;
            }
            
            .company-name {
                font-size: 20px;
            }
            
            .company-address {
                font-size: 10px;
            }
            
            .invoice-title {
                font-size: 16px;
                margin: 10px 0 8px 0;
            }
            
            .invoice-info {
                margin-bottom: 15px;
            }
            
            .info-row {
                margin-bottom: 3px;
            }
            
            .product-table {
                font-size: 10px;
            }
            
            .product-table th,
            .product-table td {
                padding: 6px;
            }
            
            .total-section {
                margin-top: 15px;
            }
            
            .payment-info {
                margin: 15px 0;
                padding: 10px;
            }
            
            .terms {
                margin-top: 20px;
                font-size: 9px;
            }
            
            .signature-section {
                margin-top: 30px;
            }
            
            .footer {
                margin-top: 20px;
                font-size: 9px;
            }
            
            .no-print, .print-actions {
                display: none !important;
            }
            
            /* Memastikan alignment konsisten saat print */
            .invoice-info-left, .invoice-info-right {
                width: 48%;
            }
            
            .info-label {
                width: 120px;
                font-weight: bold;
            }
            
            .info-value {
                flex: 1;
            }
            
            /* Memastikan tabel rapi */
            .product-table {
                width: 100%;
                border-collapse: collapse;
            }
            
            .product-table th {
                background-color: #f5f5f5;
                font-weight: bold;
                text-align: left;
            }
            
            .product-table .text-right {
                text-align: right;
            }
            
            /* Memastikan total section rapi */
            .total-row {
                display: flex;
                justify-content: space-between;
                margin-bottom: 3px;
            }
            
            .total-label {
                font-weight: bold;
                width: 150px;
            }
            
            .total-value {
                width: 100px;
                text-align: right;
            }
        }
    </style>
</head>
<body>
    <!-- Tombol Aksi -->
    <div class="fixed top-5 right-5 z-50 flex gap-3 print:hidden">
        <button onclick="window.print()" class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-medium text-sm rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5">
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                <path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"/>
            </svg>
            Print
        </button>
        <a href="<?php echo e(route('admin.print.order.invoice.download', $order)); ?>" class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white font-medium text-sm rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5">
            <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                <path d="M12,11L15,14H13V18H11V14H9L12,11Z"/>
            </svg>
            Download PDF
        </a>
    </div>
    
    <div class="content-container">
        <!-- Header Perusahaan -->
        <div class="header">
            <div class="company-name">POLJAM TECHNO WORKSHOP</div>
            <div class="company-address">Jl. Workshop No. 123, Jakarta</div>
            <div class="company-address">Telp: (021) 123-4567 | Email: info@poljamtechno.com</div>
        </div>
        
        <!-- Judul Nota -->
        <div class="invoice-title">NOTA PEMESANAN</div>
        
        <!-- Informasi Nota -->
        <div class="invoice-info">
            <div class="invoice-info-left">
                <div class="info-row">
                    <div class="info-label">No. Nota:</div>
                    <div class="info-value">#ORD-<?php echo e($order->id); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Tanggal:</div>
                    <div class="info-value"><?php echo e($order->created_at->format('d M Y')); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Customer:</div>
                    <div class="info-value"><?php echo e($order->customer_name); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Email:</div>
                    <div class="info-value"><?php echo e($order->customer_email); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Telepon:</div>
                    <div class="info-value"><?php echo e($order->phone_number); ?></div>
                </div>
            </div>
            <div class="invoice-info-right">
                <div class="info-row">
                    <div class="info-label">Status:</div>
                    <div class="info-value"><?php echo e($order->order_status_label); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Pembayaran:</div>
                    <div class="info-value"><?php echo e(ucfirst($order->payment_method)); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Produksi:</div>
                    <div class="info-value"><?php echo e($order->production_status_label); ?></div>
                </div>
            </div>
        </div>
        
    <!-- Alamat Customer -->
    <div class="info-row">
        <div class="info-label">Alamat:</div>
        <div class="info-value"><?php echo e($order->address); ?></div>
    </div>
    
    <!-- Detail Produk -->
    <div class="product-section">
        <table class="product-table">
            <thead>
                <tr>
                    <th>Produk</th>
                    <th>Qty</th>
                    <th class="text-right">Harga Satuan</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($order->product->product_title ?? 'N/A'); ?></td>
                    <td><?php echo e($order->quantity); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($order->price, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    
    <!-- Total -->
    <div class="total-section">
        <div class="total-row">
            <div class="total-label">Subtotal:</div>
            <div class="total-value">Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?></div>
        </div>
        <div class="total-row grand-total">
            <div class="total-label">TOTAL:</div>
            <div class="total-value">Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?></div>
        </div>
    </div>
    
    <!-- Informasi Pembayaran -->
    <div class="payment-info">
        <strong>Informasi Pembayaran:</strong><br>
        <?php if($order->payment_method === 'dp'): ?>
            <span style="color: #e74c3c;">⚠️ PEMBAYARAN DP - Sisa pembayaran saat mesin selesai</span>
        <?php elseif($order->payment_method === 'transfer'): ?>
            <span style="color: #f39c12;">⏳ Menunggu konfirmasi pembayaran transfer</span>
        <?php elseif($order->payment_method === 'cod'): ?>
            <span style="color: #27ae60;">✅ Bayar saat barang sampai</span>
        <?php endif; ?>
    </div>
    
    <!-- Syarat & Ketentuan -->
    <div class="terms">
        <strong>Syarat & Ketentuan:</strong><br>
        1. Estimasi pengerjaan: 30 hari kerja<br>
        2. Garansi 1 tahun untuk mesin yang diproduksi<br>
        3. Pembayaran lunas sebelum pengiriman (kecuali COD)<br>
        4. Perubahan spesifikasi setelah produksi dimulai dikenakan biaya tambahan<br>
        5. Nota ini berlaku sebagai kontrak pemesanan
    </div>
    
    <!-- Tanda Tangan -->
    <div class="signature-section">
        <div class="signature-box">
            <div>Customer</div>
            <div class="signature-line"></div>
            <div>(<?php echo e($order->customer_name); ?>)</div>
        </div>
        <div class="signature-box">
            <div>Admin Workshop</div>
            <div class="signature-line"></div>
            <div>(________________)</div>
        </div>
    </div>
    
        <!-- Footer -->
        <div class="footer">
            Terima kasih atas kepercayaan Anda kepada POLJAM TECHNO WORKSHOP<br>
            Nota ini dicetak pada <?php echo e(now()->format('d M Y H:i')); ?>

        </div>
    </div>
</body>
</html>
<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/print/order-invoice.blade.php ENDPATH**/ ?>