

<?php $__env->startSection('title', 'Edit Produk'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <a href="<?php echo e(route('admin.master.products.index', isset($queryParams) ? $queryParams : [])); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Edit Produk Jasa</h1>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
        <form action="<?php echo e(route('admin.master.products.update', $product->id)); ?>" method="POST" enctype="multipart/form-data" class="p-5" onsubmit="return validateForm()">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <!-- Hidden inputs untuk menyimpan query parameters -->
            <?php if(isset($queryParams)): ?>
                <?php $__currentLoopData = $queryParams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($value): ?>
                        <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Kiri: Data Produk & Relasi (2 kolom) -->
                <div class="lg:col-span-2 space-y-5">
                    <!-- Informasi Dasar Produk -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <h3 class="text-base font-semibold text-gray-800 dark:text-gray-200 mb-4 flex items-center">
                            <i class="fas fa-info-circle mr-2 text-blue-600 dark:text-blue-400"></i>
                            Informasi Dasar Produk
                        </h3>
                        
                        <!-- Nama Produk -->
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Nama Produk <span class="text-red-500">*</span></label>
                            <input type="text" name="product_title" value="<?php echo e(old('product_title', $product->product_title)); ?>" required
                                class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php $__errorArgs = ['product_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Masukkan nama produk">
                            <?php $__errorArgs = ['product_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Deskripsi -->
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Deskripsi Produk</label>
                            <!-- Quill Editor Container -->
                            <div class="quill-editor-wrapper <?php $__errorArgs = ['product_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <div id="product_description_editor" style="min-height: 200px;"></div>
                            </div>
                            <!-- Hidden input untuk menyimpan HTML content -->
                            <input type="hidden" name="product_description" id="product_description_input" value="<?php echo e(old('product_description', $product->product_description)); ?>">
                            <?php $__errorArgs = ['product_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Kategori -->
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kategori Produk <span class="text-red-500">*</span></label>
                            <select name="category_id" required
                                class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">Pilih Kategori</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"
                                        <?php echo e(old('category_id', $product->category_id ?? null) == $category->id ? 'selected' : ''); ?>>
                                        <?php echo e($category->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>


                        <!-- Lama Pengerjaan & Garansi -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Lama Pengerjaan</label>
                                <input type="text" name="product_work_duration" value="<?php echo e(old('product_work_duration', $product->product_work_duration)); ?>"
                                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php $__errorArgs = ['product_work_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="cth: 7 hari kerja">
                                <?php $__errorArgs = ['product_work_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Garansi</label>
                                <input type="text" name="product_garansi" value="<?php echo e(old('product_garansi', $product->product_garansi)); ?>"
                                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php $__errorArgs = ['product_garansi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="cth: 1 tahun">
                                <?php $__errorArgs = ['product_garansi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Status Aktif Produk -->
                        <div class="mt-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Status Produk</label>
                            <div class="flex items-center">
                                <label for="is_active" class="flex items-center cursor-pointer select-none">
                                    <input type="checkbox" name="is_active" id="is_active" value="1"
                                           <?php echo e(old('is_active', $product->is_active) ? 'checked' : ''); ?>

                                           class="sr-only peer">
                                    <div class="w-12 h-6 bg-gray-300 dark:bg-gray-600 rounded-full relative transition 
                                                peer-checked:bg-green-500">
                                        <span class="absolute top-0.5 left-0.5 w-5 h-5 bg-white rounded-full shadow transition-all 
                                                     peer-checked:left-6"></span>
                                    </div>
                                    <span class="ml-3 text-sm text-gray-700 dark:text-gray-300 peer-checked:text-green-600">Aktif</span>
                                </label>
                                <span class="ml-3 text-xs text-gray-500 dark:text-gray-400">Nonaktif akan menyembunyikan produk dari daftar.</span>
                            </div>
                        </div>
                    </div>

                    <!-- Materials Dinamis -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-2 flex items-center">
                            <i class="fas fa-hammer mr-2 text-blue-600 dark:text-blue-400"></i>
                            Bahan yang Digunakan
                        </label>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-4">Tambahkan bahan yang diperlukan untuk produk ini. Anda bisa mengisi nama bahan bebas.</p>
                        <div id="materialsContainer" class="space-y-3">
                            <?php $materialIndex = 0; ?>
                            <?php $__empty_1 = true; $__currentLoopData = ($product->materials ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedMaterial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="material-item bg-white dark:bg-gray-800 p-3 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                                    <div class="flex items-end gap-2">
                                        <div class="flex-1 grid grid-cols-1 md:grid-cols-3 gap-2">
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Nama Bahan</label>
                                                <input type="text" name="product_materials[<?php echo e($materialIndex); ?>][name]" placeholder="Contoh: Plat Baja, Stainless Steel, dll" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_materials.' . $materialIndex . '.name', $selectedMaterial->name ?? '')); ?>">
                                                <input type="hidden" name="product_materials[<?php echo e($materialIndex); ?>][type]" value="material">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Jumlah</label>
                                                <input type="number" name="product_materials[<?php echo e($materialIndex); ?>][quantity]" placeholder="0" min="1" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_materials.' . $materialIndex . '.quantity', $selectedMaterial->quantity ?? 1)); ?>">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Satuan</label>
                                                <input type="text" name="product_materials[<?php echo e($materialIndex); ?>][unit]" placeholder="cth: pcs, kg, meter, dll" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_materials.' . $materialIndex . '.unit', $selectedMaterial->unit ?? '')); ?>">
                                            </div>
                                        </div>
                                        <button type="button" onclick="removeRow(this)"
                                            class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                                            <i class="fas fa-times text-sm"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php $materialIndex++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <!-- Tidak ada bahan awal -->
                            <?php endif; ?>
                        </div>
                        <button type="button" onclick="addMaterial()"
                            class="mt-4 bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-lg transition-colors duration-200 flex items-center font-medium">
                            <i class="fas fa-plus mr-2"></i>Tambah Bahan
                        </button>
                    </div>

                    <!-- Spareparts Dinamis -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-2 flex items-center">
                            <i class="fas fa-cogs mr-2 text-green-600 dark:text-green-400"></i>
                            Sparepart yang Digunakan
                        </label>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-4">Tambahkan sparepart yang diperlukan untuk produk ini. Anda bisa mengisi nama sparepart bebas.</p>
                        <div id="sparepartsContainer" class="space-y-3">
                            <?php $sparepartIndexPrefill = 0; ?>
                            <?php $__empty_1 = true; $__currentLoopData = ($product->spareparts ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedSparepart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="sparepart-item bg-white dark:bg-gray-800 p-3 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                                    <div class="flex items-end gap-2">
                                        <div class="flex-1 grid grid-cols-1 md:grid-cols-3 gap-2">
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Nama Sparepart</label>
                                                <input type="text" name="product_spareparts[<?php echo e($sparepartIndexPrefill); ?>][name]" placeholder="Contoh: Baut M8, Bearing, dll" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_spareparts.' . $sparepartIndexPrefill . '.name', $selectedSparepart->name ?? '')); ?>">
                                                <input type="hidden" name="product_spareparts[<?php echo e($sparepartIndexPrefill); ?>][type]" value="sparepart">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Jumlah</label>
                                                <input type="number" name="product_spareparts[<?php echo e($sparepartIndexPrefill); ?>][quantity]" placeholder="0" min="1" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_spareparts.' . $sparepartIndexPrefill . '.quantity', $selectedSparepart->quantity ?? 1)); ?>">
                                            </div>
                                            <div>
                                                <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Satuan</label>
                                                <input type="text" name="product_spareparts[<?php echo e($sparepartIndexPrefill); ?>][unit]" placeholder="cth: pcs, kg, meter, dll" required
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_spareparts.' . $sparepartIndexPrefill . '.unit', $selectedSparepart->unit ?? '')); ?>">
                                            </div>
                                        </div>
                                        <button type="button" onclick="removeRow(this)"
                                            class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                                            <i class="fas fa-times text-sm"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php $sparepartIndexPrefill++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <!-- Tidak ada sparepart awal -->
                            <?php endif; ?>
                        </div>
                        <button type="button" onclick="addSparepart()"
                            class="mt-4 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg transition-colors duration-200 flex items-center font-medium">
                            <i class="fas fa-plus mr-2"></i>Tambah Sparepart
                        </button>
                    </div>

                    <!-- Specifications Dinamis -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-4 flex items-center">
                            <i class="fas fa-list-alt mr-2 text-orange-600 dark:text-orange-400"></i>
                            Spesifikasi Produk (Opsional)
                        </label>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-4">Tambahkan spesifikasi seperti dimensi, kapasitas, dll.</p>
                        
                        <div id="specificationsContainer" class="space-y-3">
                            <?php $specIndexPrefill = 0; ?>
                            <?php $__empty_1 = true; $__currentLoopData = ($product->specifications ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="spec-item bg-white dark:bg-gray-800 p-3 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                                    <div class="flex items-end gap-2">
                                        <div class="flex-1 grid grid-cols-2 gap-2">
                                            <div>
                                                <input type="text" name="product_specifications[<?php echo e($specIndexPrefill); ?>][key]" placeholder="Nama spesifikasi (cth: Panjang)"
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_specifications.' . $specIndexPrefill . '.key', $spec->key)); ?>">
                                            </div>
                                            <div>
                                                <input type="text" name="product_specifications[<?php echo e($specIndexPrefill); ?>][value]" placeholder="Nilai (cth: 150 cm)"
                                                    class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                                    value="<?php echo e(old('product_specifications.' . $specIndexPrefill . '.value', $spec->value)); ?>">
                                            </div>
                                        </div>
                                        <button type="button" onclick="removeRow(this)"
                                            class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                                            <i class="fas fa-times text-sm"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php $specIndexPrefill++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <!-- Tidak ada spesifikasi awal -->
                            <?php endif; ?>
                        </div>
                        
                        <button type="button" onclick="addSpecification()"
                            class="mt-4 bg-orange-500 hover:bg-orange-600 text-white px-4 py-2 rounded-lg transition-colors duration-200 flex items-center font-medium">
                            <i class="fas fa-plus mr-2"></i>Tambah Spesifikasi
                        </button>
                    </div>

                    <!-- Kalkulasi Biaya -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <h3 class="text-base font-semibold text-gray-800 dark:text-gray-200 mb-4 flex items-center">
                            <i class="fas fa-calculator mr-2 text-purple-600 dark:text-purple-400"></i>
                            Kalkulasi Biaya Produk
                        </h3>
                        
                        <!-- Harga Produk -->
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Harga Produk (Rp) <span class="text-red-500">*</span></label>
                            <input type="number" name="product_prices" id="product_prices" placeholder="Harga jual produk" min="1" value="<?php echo e(old('product_prices', $product->product_prices)); ?>"
                                class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php $__errorArgs = ['product_prices'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 dark:border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                onchange="calculateProfit()" required>
                            <?php $__errorArgs = ['product_prices'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Upah Jasa -->
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Upah Jasa Pengerjaan (Rp)</label>
                            <input type="number" name="service_fee" id="service_fee" placeholder="Upah jasa" min="0" value="<?php echo e(old('service_fee', $product->service_fee)); ?>"
                                class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white transition-colors duration-200 <?php if(isset($mismatchedProductions) && $mismatchedProductions->count() > 0): ?> border-orange-500 dark:border-orange-500 <?php endif; ?>"
                                onchange="calculateProfit()">
                            
                            <?php if(isset($mismatchedProductions) && $mismatchedProductions->count() > 0): ?>
                                <div class="mt-3 bg-orange-50 dark:bg-orange-900/20 border border-orange-200 dark:border-orange-700 rounded-lg p-4">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0">
                                            <i class="fas fa-exclamation-triangle text-orange-600 dark:text-orange-400 text-lg"></i>
                                        </div>
                                        <div class="ml-3 flex-1">
                                            <h4 class="text-sm font-semibold text-orange-800 dark:text-orange-200 mb-2">
                                                Peringatan: Ada <?php echo e($mismatchedProductions->count()); ?> produksi dengan labor cost berbeda!
                                            </h4>
                                            <p class="text-xs text-orange-700 dark:text-orange-300 mb-3">
                                                Upah jasa yang Anda input (Rp <?php echo e(number_format($product->service_fee ?? 0, 0, ',', '.')); ?>) tidak sesuai dengan labor cost yang diinput teknisi pada beberapa produksi. Pertimbangkan untuk memperbarui nilai ini.
                                            </p>
                                            <div class="mt-3 space-y-2 max-h-48 overflow-y-auto">
                                                <?php $__currentLoopData = $mismatchedProductions->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="bg-white dark:bg-gray-800 rounded p-2 text-xs border border-orange-200 dark:border-orange-700">
                                                        <div class="flex justify-between items-center">
                                                            <div>
                                                                <span class="font-medium text-gray-900 dark:text-gray-100">
                                                                    Production #<?php echo e($production->id); ?>

                                                                </span>
                                                                <?php if($production->order): ?>
                                                                    <span class="text-gray-600 dark:text-gray-400">
                                                                        - Order #<?php echo e($production->order->order_number ?? $production->order->id); ?>

                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <span class="font-semibold <?php echo e($production->labor_cost > ($product->service_fee ?? 0) ? 'text-red-600 dark:text-red-400' : 'text-green-600 dark:text-green-400'); ?>">
                                                                Rp <?php echo e(number_format($production->labor_cost, 0, ',', '.')); ?>

                                                            </span>
                                                        </div>
                                                        <div class="mt-1 text-gray-600 dark:text-gray-400">
                                                            <span class="text-gray-500">Default: Rp <?php echo e(number_format($product->service_fee ?? 0, 0, ',', '.')); ?></span>
                                                            <span class="mx-2">•</span>
                                                            <span class="<?php echo e($production->labor_cost > ($product->service_fee ?? 0) ? 'text-red-600' : 'text-green-600'); ?>">
                                                                Selisih: <?php echo e($production->labor_cost > ($product->service_fee ?? 0) ? '+' : ''); ?>Rp <?php echo e(number_format(abs($production->labor_cost - ($product->service_fee ?? 0)), 0, ',', '.')); ?>

                                                            </span>
                                                            <?php if($production->notes): ?>
                                                                <div class="mt-1 text-gray-500 italic">
                                                                    <i class="fas fa-comment"></i> <?php echo e(Str::limit($production->notes, 50)); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($mismatchedProductions->count() > 5): ?>
                                                    <p class="text-xs text-orange-600 dark:text-orange-400 text-center italic">
                                                        ... dan <?php echo e($mismatchedProductions->count() - 5); ?> produksi lainnya
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Summary Biaya -->
                        <div class="bg-white dark:bg-gray-700/50 p-4 rounded-lg border border-gray-200 dark:border-gray-600">
                            <h4 class="font-semibold text-gray-800 dark:text-gray-200 mb-3">Ringkasan Biaya & Keuntungan:</h4>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-600 dark:text-gray-400">Upah Jasa:</span>
                                    <span id="service_fee_display" class="font-semibold text-purple-600 dark:text-purple-400">Rp 0</span>
                                </div>
                                <hr class="border-gray-300 dark:border-gray-700">
                                <div class="flex justify-between text-lg font-bold">
                                    <span class="text-gray-800 dark:text-gray-200">Harga Jual Produk:</span>
                                    <span id="product_price_display" class="text-blue-600 dark:text-blue-400">Rp 0</span>
                                </div>
                                <hr class="border-gray-300 dark:border-gray-700">
                                <div class="flex justify-between text-xl font-bold">
                                    <span class="text-gray-800 dark:text-gray-200">Keuntungan:</span>
                                    <span id="profit_amount" class="text-green-600 dark:text-green-400">Rp 0</span>
                                </div>
                                <div class="flex justify-between text-sm">
                                    <span class="text-gray-600 dark:text-gray-400">Persentase Keuntungan:</span>
                                    <span id="profit_percentage" class="font-semibold text-green-600 dark:text-green-400">0%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Kanan: Gambar (1 kolom) -->
                <div class="space-y-5">
                    <!-- Gambar Utama -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-4 flex items-center">
                            <i class="fas fa-image mr-2 text-orange-600 dark:text-orange-400"></i>
                            Gambar Utama
                        </label>
                        <div class="relative">
                            <input type="file" name="product_image" id="product_image" accept="image/*"
                                class="hidden" onchange="previewMainImage(event)">
                            <label for="product_image"
                                class="flex items-center justify-center w-full h-24 bg-gray-50 dark:bg-gray-800 border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-gray-400 dark:hover:border-gray-500 transition duration-300">
                                <i class="fas fa-cloud-upload-alt text-2xl text-orange-400 dark:text-orange-500 mr-2"></i>
                                <span class="text-sm text-gray-600 dark:text-gray-300 font-medium">Upload gambar utama</span>
                            </label>
                            <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">Unggah minimal 1 gambar (jpg, jpeg, png, max 2MB).</p>
                            <?php $__errorArgs = ['product_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <!-- Preview Gambar Utama -->
                            <input type="hidden" name="remove_main_image" id="remove_main_image" value="0">
                            <div id="mainImagePreviewContainer" style="<?php echo e(($product->product_image && file_exists(public_path('uploads/products/' . $product->product_image))) ? '' : 'display:none;'); ?>"
                                class="relative mt-4 w-full h-64 bg-gray-50 dark:bg-gray-700/50 rounded-lg border-2 <?php echo e(($product->product_image && file_exists(public_path('uploads/products/' . $product->product_image))) ? 'border-solid border-gray-200 dark:border-gray-600' : 'border-dashed border-gray-300 dark:border-gray-600'); ?> overflow-hidden transition-colors duration-300">
                                <img id="previewImage" class="w-full h-full object-contain" 
                                     <?php if($product->product_image && file_exists(public_path('uploads/products/' . $product->product_image))): ?>
                                         src="<?php echo e(asset('uploads/products/' . $product->product_image)); ?>"
                                         style="background: transparent;"
                                     <?php else: ?>
                                         style="background: transparent;"
                                     <?php endif; ?>>
                                <button type="button" id="removeMainImage"
                                    class="absolute top-2 right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition">
                                    <i class="fas fa-times text-sm"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Gambar Tambahan -->
                    <div class="bg-gray-50 dark:bg-gray-800/50 p-5 rounded-lg border border-gray-200 dark:border-gray-700 transition-colors duration-300">
                        <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-4 flex items-center">
                            <i class="fas fa-images mr-2 text-cyan-600 dark:text-cyan-400"></i>
                            Gambar Tambahan
                        </label>
                        
                        <!-- Upload Area -->
                        <div class="relative mb-4">
                            <input type="file" name="product_images[]" accept="image/*" id="product_images" multiple
                                class="hidden" onchange="previewAdditionalImages(event)">
                            <label for="product_images"
                                class="flex items-center justify-center w-full h-32 bg-gray-50 dark:bg-gray-800 border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-gray-400 dark:hover:border-gray-500 transition duration-300">
                                <div class="text-center">
                                    <i class="fas fa-cloud-upload-alt text-3xl text-cyan-400 dark:text-cyan-500 mb-2"></i>
                                    <p class="text-sm text-gray-600 dark:text-gray-300 font-medium">Klik untuk upload gambar (bisa pilih banyak)</p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Maksimal 5 gambar (jpg, jpeg, png, max 2MB)</p>
                                </div>
                            </label>
                        </div>

                        <!-- Gambar Tersimpan -->
                        <?php if($product->images && $product->images->count() > 0): ?>
                            <input type="hidden" name="remove_images" id="remove_images" value="">
                            <div class="mb-4">
                                <label class="text-sm font-semibold text-gray-800 dark:text-gray-200 mb-2 flex items-center">
                                    <i class="fas fa-photo-video mr-2 text-cyan-600 dark:text-cyan-400"></i>
                                    Gambar Tersimpan
                                </label>
                                <div id="existingImagesContainer" class="grid grid-cols-2 gap-3">
                                    <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="relative border border-gray-200 dark:border-gray-600 rounded-lg overflow-hidden bg-gray-50 dark:bg-gray-700/50" data-image-id="<?php echo e($img->id); ?>">
                                            <img src="<?php echo e(asset('uploads/products/' . $img->image_path)); ?>" alt="Gambar" class="w-full h-32 object-contain p-2" style="background: transparent;">
                                            <button type="button" onclick="removeExistingImage(<?php echo e($img->id); ?>, this)"
                                                class="absolute top-2 right-2 bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition">
                                                <i class="fas fa-times text-sm"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Upload Satu per Satu -->
                        <div class="mb-4">
                            <button type="button" onclick="addSingleImageUpload()"
                                class="w-full bg-cyan-500 hover:bg-cyan-600 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200 flex items-center justify-center">
                                <i class="fas fa-plus mr-2"></i>
                                Tambah Gambar Satu per Satu
                            </button>
                        </div>

                        <!-- Container untuk upload satu per satu -->
                        <div id="singleImageUploads" class="space-y-3"></div>

                        <!-- Preview Container -->
                        <div id="additionalImagesPreview" class="mt-4 grid grid-cols-2 gap-3"></div>
                    </div>
                </div>
            </div>

            <!-- Tombol Submit dan Cancel -->
            <div class="flex flex-col sm:flex-row justify-end space-y-3 sm:space-y-0 sm:space-x-3 pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="<?php echo e(route('admin.master.products.index', isset($queryParams) ? $queryParams : [])); ?>"
                    class="flex items-center justify-center px-6 py-3 text-gray-600 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200 font-medium">
                    Batal
                </a>
                <button type="submit"
                    class="flex items-center justify-center bg-blue-500 hover:bg-blue-600 text-white font-medium py-3 px-6 rounded-lg transition-colors duration-200">
                    <i class="fas fa-save mr-2"></i>
                    <span>Perbarui Produk</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Quill.js CSS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    
    <!-- Quill.js JS -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

    <style>
        /* Quill Editor Styling */
        .quill-editor-wrapper {
            border: 1px solid rgb(209 213 219);
            border-radius: 0.5rem;
            background: white;
            overflow: hidden;
        }
        
        .dark .quill-editor-wrapper {
            border-color: rgb(75 85 99);
            background: rgb(55 65 81);
        }
        
        .quill-editor-wrapper .ql-toolbar {
            border: none !important;
            border-bottom: 1px solid rgb(209 213 219) !important;
            background: rgb(249 250 251);
            padding: 8px;
            margin: 0;
        }
        
        .dark .quill-editor-wrapper .ql-toolbar {
            border-bottom-color: rgb(75 85 99) !important;
            background: rgb(55 65 81);
        }
        
        .quill-editor-wrapper .ql-container {
            border: none !important;
            font-family: inherit;
            font-size: 14px;
        }
        
        .quill-editor-wrapper .ql-toolbar.ql-snow {
            border: none !important;
            border-bottom: 1px solid rgb(209 213 219) !important;
        }
        
        .dark .quill-editor-wrapper .ql-toolbar.ql-snow {
            border-bottom-color: rgb(75 85 99) !important;
        }
        
        .quill-editor-wrapper .ql-editor {
            min-height: 200px;
            color: rgb(17 24 39);
            padding: 12px 16px;
        }
        
        .dark .quill-editor-wrapper .ql-editor {
            color: rgb(243 244 246);
        }
        
        .quill-editor-wrapper .ql-editor.ql-blank::before {
            color: rgb(156 163 175);
            font-style: normal;
        }
        
        .dark .quill-editor-wrapper .ql-editor.ql-blank::before {
            color: rgb(156 163 175);
        }
        
        .quill-editor-wrapper .ql-stroke {
            stroke: rgb(107 114 128);
        }
        
        .dark .quill-editor-wrapper .ql-stroke {
            stroke: rgb(156 163 175);
        }
        
        .quill-editor-wrapper .ql-fill {
            fill: rgb(107 114 128);
        }
        
        .dark .quill-editor-wrapper .ql-fill {
            fill: rgb(156 163 175);
        }
        
        .quill-editor-wrapper .ql-picker-label {
            color: rgb(107 114 128);
        }
        
        .dark .quill-editor-wrapper .ql-picker-label {
            color: rgb(156 163 175);
        }
        
        .quill-editor-wrapper .ql-toolbar button:hover,
        .quill-editor-wrapper .ql-toolbar button.ql-active {
            color: rgb(59 130 246);
        }
        
        .dark .quill-editor-wrapper .ql-toolbar button:hover,
        .dark .quill-editor-wrapper .ql-toolbar button.ql-active {
            color: rgb(96 165 250);
        }
    </style>

    <script>
        let materialIndex = <?php echo e(isset($product) && isset($product->materials) ? $product->materials->count() : 0); ?>;
        let sparepartIndex = <?php echo e(isset($product) && isset($product->spareparts) ? $product->spareparts->count() : 0); ?>;
        let specIndex = <?php echo e(isset($product) && isset($product->specifications) ? $product->specifications->count() : 0); ?>;
        let extraFiles = [];
        let singleImageIndex = 0;
        let removeImageIds = [];

        // Preview Gambar Utama
        const mainImageInput = document.getElementById('product_image');
        const previewImage = document.getElementById('previewImage');
        const mainImagePreviewContainer = document.getElementById('mainImagePreviewContainer');
        const removeMainImageBtn = document.getElementById('removeMainImage');

        mainImageInput.addEventListener('change', function(event) {
            const file = event.target.files[0];

            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    previewImage.src = e.target.result;
                    previewImage.style.background = 'transparent';
                    mainImagePreviewContainer.style.display = 'block';
                    mainImagePreviewContainer.classList.remove('border-dashed');
                    mainImagePreviewContainer.classList.add('border-solid');
                };
                reader.readAsDataURL(file);
            }
        });

        removeMainImageBtn.addEventListener('click', function() {
            mainImageInput.value = '';
            previewImage.src = '';
            previewImage.style.background = '';
            mainImagePreviewContainer.style.display = 'none';
            mainImagePreviewContainer.classList.add('border-dashed');
            mainImagePreviewContainer.classList.remove('border-solid');
            const rm = document.getElementById('remove_main_image');
            if (rm) rm.value = '1';
        });

        // Preview gambar tambahan dengan remove button
        function previewAdditionalImages(event) {
            const previewContainer = document.getElementById('additionalImagesPreview');
            const input = event.target;
            previewContainer.innerHTML = '';
            extraFiles = Array.from(input.files).slice(0, 5);

            extraFiles.forEach((file, index) => {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = 'relative';
                    div.innerHTML = `
                        <img src="${e.target.result}" class="w-full h-32 object-contain rounded border border-gray-200 dark:border-gray-600" style="background: transparent;">
                        <button type="button" onclick="removeExtraImage(${index})"
                            class="absolute -top-1 -right-1 bg-red-500 hover:bg-red-600 text-white rounded-full w-6 h-6 flex items-center justify-center transition-colors duration-200">
                            <i class="fas fa-times text-xs"></i>
                        </button>
                    `;
                    previewContainer.appendChild(div);
                };
                reader.readAsDataURL(file);
            });
        }

        function removeExtraImage(index) {
            extraFiles.splice(index, 1);
            const dataTransfer = new DataTransfer();
            extraFiles.forEach(file => dataTransfer.items.add(file));
            document.getElementById('product_images').files = dataTransfer.files;

            // Re-render preview
            const event = new Event('change', {
                bubbles: true
            });
            document.getElementById('product_images').dispatchEvent(event);
        }

        // Upload gambar satu per satu
        function addSingleImageUpload() {
            const container = document.getElementById('singleImageUploads');
            const div = document.createElement('div');
            div.className = 'single-image-upload bg-white dark:bg-gray-600 p-4 rounded-lg border border-cyan-200 dark:border-cyan-600 transition-colors duration-300';
                    div.innerHTML = `
                <div class="flex items-center space-x-3">
                    <input type="file" name="product_images[]" accept="image/*" id="single_image_${singleImageIndex}" 
                        class="hidden" onchange="previewSingleImage(this, ${singleImageIndex})">
                    <label for="single_image_${singleImageIndex}" 
                        class="flex-1 flex items-center justify-center h-20 bg-gray-50 dark:bg-gray-800 border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-gray-400 dark:hover:border-gray-500 transition duration-300">
                        <div class="text-center">
                            <i class="fas fa-image text-lg text-cyan-400 dark:text-cyan-500 mr-2"></i>
                            <span class="text-sm text-gray-600 dark:text-gray-300">Pilih Gambar</span>
                        </div>
                    </label>
                    <button type="button" onclick="removeSingleImageUpload(this)" 
                        class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition duration-200">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
                <div id="single_preview_${singleImageIndex}" class="mt-3 hidden">
                    <img id="single_img_${singleImageIndex}" class="w-full h-32 object-contain rounded border border-gray-200 dark:border-gray-600" style="background: transparent;">
                </div>
            `;
            container.appendChild(div);
            singleImageIndex++;
        }

        // Preview gambar satu per satu
        function previewSingleImage(input, index) {
            const file = input.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const previewImg = document.getElementById(`single_img_${index}`);
                    const previewDiv = document.getElementById(`single_preview_${index}`);
                    previewImg.src = e.target.result;
                    previewDiv.classList.remove('hidden');
                };
                reader.readAsDataURL(file);
            }
        }

        // Hapus gambar tersimpan langsung
        function removeExistingImage(id, btn) {
            // Tambahkan ID ke array untuk dikirim ke server
            if (removeImageIds.indexOf(id) === -1) {
                removeImageIds.push(id);
            }
            
            // Update hidden input
            const hidden = document.getElementById('remove_images');
            if (hidden) hidden.value = removeImageIds.join(',');
            
            // Hapus elemen gambar dari DOM langsung
            const imageContainer = btn.closest('[data-image-id]');
            if (imageContainer) {
                imageContainer.remove();
            }
            
            // Cek jika tidak ada gambar tersisa, sembunyikan container
            const container = document.getElementById('existingImagesContainer');
            if (container && container.children.length === 0) {
                container.closest('.mb-4').style.display = 'none';
            }
        }

        // Hapus upload gambar satu per satu
        function removeSingleImageUpload(button) {
            const container = button.closest('.single-image-upload');
            container.remove();
        }

        // Tambah Material
        function addMaterial() {
            const container = document.getElementById('materialsContainer');
            const div = document.createElement('div');
            div.className = 'material-item bg-white dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600 transition-colors duration-300';
            div.innerHTML = `
                <div class="flex items-end gap-2">
                    <div class="flex-1 grid grid-cols-1 md:grid-cols-3 gap-2">
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Nama Bahan</label>
                            <input type="text" name="product_materials[${materialIndex}][name]" placeholder="Contoh: Plat Baja, Stainless Steel, dll" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            <input type="hidden" name="product_materials[${materialIndex}][type]" value="material">
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Jumlah</label>
                            <input type="number" name="product_materials[${materialIndex}][quantity]" placeholder="0" min="1" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Satuan</label>
                            <input type="text" name="product_materials[${materialIndex}][unit]" placeholder="cth: pcs, kg, meter, dll" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                    </div>
                    <button type="button" onclick="removeRow(this)"
                        class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
            `;
            container.appendChild(div);
            materialIndex++;
        }

        // Tambah Sparepart
        function addSparepart() {
            const container = document.getElementById('sparepartsContainer');
            const div = document.createElement('div');
            div.className = 'sparepart-item bg-white dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600 transition-colors duration-300';
            div.innerHTML = `
                <div class="flex items-end gap-2">
                    <div class="flex-1 grid grid-cols-1 md:grid-cols-3 gap-2">
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Nama Sparepart</label>
                            <input type="text" name="product_spareparts[${sparepartIndex}][name]" placeholder="Contoh: Baut M8, Bearing, dll" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                            <input type="hidden" name="product_spareparts[${sparepartIndex}][type]" value="sparepart">
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Jumlah</label>
                            <input type="number" name="product_spareparts[${sparepartIndex}][quantity]" placeholder="0" min="1" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-1">Satuan</label>
                            <input type="text" name="product_spareparts[${sparepartIndex}][unit]" placeholder="cth: pcs, kg, meter, dll" required
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                    </div>
                    <button type="button" onclick="removeRow(this)"
                        class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
            `;
            container.appendChild(div);
            sparepartIndex++;
        }

        // Tambah Spesifikasi
        function addSpecification() {
            const container = document.getElementById('specificationsContainer');
            const div = document.createElement('div');
            div.className = 'spec-item bg-white dark:bg-gray-700/50 p-3 rounded-lg border border-gray-200 dark:border-gray-600 transition-colors duration-300';
            div.innerHTML = `
                <div class="flex items-end gap-2">
                    <div class="flex-1 grid grid-cols-2 gap-2">
                        <div>
                            <input type="text" name="product_specifications[${specIndex}][key]" placeholder="Nama spesifikasi (cth: Panjang)"
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                        <div>
                            <input type="text" name="product_specifications[${specIndex}][value]" placeholder="Nilai (cth: 150 cm)"
                                class="w-full px-2.5 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 dark:bg-gray-700 dark:text-white transition-colors duration-200">
                        </div>
                    </div>
                    <button type="button" onclick="removeRow(this)"
                        class="bg-red-500 hover:bg-red-600 text-white rounded-lg w-8 h-8 flex items-center justify-center transition-colors duration-200 flex-shrink-0">
                        <i class="fas fa-times text-sm"></i>
                    </button>
                </div>
            `;
            container.appendChild(div);
            specIndex++;
        }

        // Remove row universal (untuk materials dan spareparts)
        function removeRow(button) {
            const parent = button.closest('.material-item, .sparepart-item, .spec-item');
            if (parent) {
                parent.remove();
            }
        }

        // Kalkulasi keuntungan
        function calculateProfit() {
            let serviceFee = parseFloat(document.getElementById('service_fee').value) || 0;
            let productPrice = parseFloat(document.getElementById('product_prices').value) || 0;

            const totalProductionCost = serviceFee;
            const profit = productPrice - totalProductionCost;
            const profitPercentage = totalProductionCost > 0 ? ((profit / totalProductionCost) * 100) : 0;

            // Update display
            document.getElementById('service_fee_display').textContent = 'Rp ' + serviceFee.toLocaleString('id-ID');
            document.getElementById('product_price_display').textContent = 'Rp ' + productPrice.toLocaleString('id-ID');
            
            // Update profit display
            const profitElement = document.getElementById('profit_amount');
            const percentageElement = document.getElementById('profit_percentage');
            
            if (profit >= 0) {
                profitElement.textContent = 'Rp ' + profit.toLocaleString('id-ID');
                profitElement.className = 'text-green-600 dark:text-green-400 text-xl font-bold';
                percentageElement.textContent = profitPercentage.toFixed(1) + '%';
                percentageElement.className = 'font-semibold text-green-600 dark:text-green-400';
            } else {
                profitElement.textContent = 'Rp ' + Math.abs(profit).toLocaleString('id-ID');
                profitElement.className = 'text-red-600 dark:text-red-400 text-xl font-bold';
                percentageElement.textContent = '-' + Math.abs(profitPercentage).toFixed(1) + '%';
                percentageElement.className = 'font-semibold text-red-600 dark:text-red-400';
            }
        }


        // Validasi form sebelum submit
        function validateForm() {
            console.log('Form validation started...');
            
            // Cek field required
            const productTitle = document.querySelector('input[name="product_title"]');
            const productPrices = document.querySelector('input[name="product_prices"]');
            const categoryId = document.querySelector('select[name="category_id"]');
            
            if (!productTitle.value.trim()) {
                alert('Nama Produk harus diisi!');
                productTitle.focus();
                return false;
            }
            
            if (!productPrices.value || productPrices.value <= 0) {
                alert('Harga Produk harus diisi dan lebih dari 0!');
                productPrices.focus();
                return false;
            }
            
            if (!categoryId.value) {
                alert('Kategori Produk harus dipilih!');
                categoryId.focus();
                return false;
            }
            
            console.log('Form validation passed, submitting...');
            return true;
        }

        // Initialize Quill Editor
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Quill
            const quillEditor = new Quill('#product_description_editor', {
                theme: 'snow',
                modules: {
                    toolbar: [
                        ['undo', 'redo'],
                        [{ 'header': [1, 2, 3, false] }],
                        ['bold', 'italic', 'underline', 'strike'],
                        [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                        [{ 'align': [] }],
                        ['link'],
                        ['clean']
                    ],
                    history: {
                        delay: 1000,
                        maxStack: 100,
                        userOnly: false
                    }
                },
                placeholder: 'Tuliskan deskripsi produk...'
            });
            
            // Load existing value
            const existingValue = document.getElementById('product_description_input').value;
            if (existingValue) {
                quillEditor.root.innerHTML = existingValue;
            }
            
            // Update hidden input when content changes
            quillEditor.on('text-change', function() {
                const html = quillEditor.root.innerHTML;
                document.getElementById('product_description_input').value = html;
            });
            
            // Also update on selection change (for formatting)
            quillEditor.on('selection-change', function() {
                const html = quillEditor.root.innerHTML;
                document.getElementById('product_description_input').value = html;
            });
            
            // Update hidden input before form submit
            const form = document.querySelector('form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    const html = quillEditor.root.innerHTML;
                    document.getElementById('product_description_input').value = html;
                    console.log('Form submit event triggered');
                    console.log('Form action:', form.action);
                    console.log('Form method:', form.method);
                });
            }
            
            // Hitung ringkasan biaya saat halaman dibuka
            calculateProfit();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/master/products/edit.blade.php ENDPATH**/ ?>