

<?php $__env->startSection('title', 'Detail Produksi - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
    $materialTotal = $production->total_material_cost ?? 0;
    $sparepartTotal = $production->total_sparepart_cost ?? 0;
    $directTotal = $materialTotal + $sparepartTotal;
    $laborTotal = $production->labor_cost ?? 0;
    $actualTotal = $directTotal + $laborTotal;
    $totalCost = $actualTotal;
?>

<div class="space-y-4">
    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center space-x-3">
            <?php
                $backRoute = $production->planning_status === 'pending_approval' 
                    ? route('supervisor.productions.planning')
                    : ($production->completion_status === 'pending_approval' 
                        ? route('supervisor.productions.completion')
                        : route('supervisor.productions.planning'));
            ?>
            <a href="<?php echo e($backRoute); ?>" 
                class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                title="Kembali">
                <i class="fas fa-arrow-left text-lg"></i>
            </a>
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Detail Produksi #<?php echo e($production->id); ?></h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Order #<?php echo e($production->order->id ?? 'N/A'); ?> · <?php echo e($production->order->customer_name ?? 'N/A'); ?>

                </p>
            </div>
        </div>
    </div>

    <!-- Notifications -->
    <?php if(session('success')): ?>
    <div class="bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg flex items-center gap-3">
        <i class="fas fa-check-circle text-green-500"></i>
        <span><?php echo e(session('success')); ?></span>
    </div>
    <?php endif; ?>

    <?php if(session('info')): ?>
    <div class="bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-800 text-blue-800 dark:text-blue-200 px-4 py-3 rounded-lg flex items-center gap-3">
        <i class="fas fa-info-circle text-blue-500"></i>
        <span><?php echo e(session('info')); ?></span>
    </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
    <div class="bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
        <ul class="list-disc list-inside text-sm">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <!-- Info Cards Row -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <!-- Info Produksi -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Produksi</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Qty:</span>
                    <span class="font-semibold text-gray-900 dark:text-white"><?php echo e($orderQty); ?> unit</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Teknisi:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs truncate"><?php echo e($production->teknisi->name ?? 'Belum ditugaskan'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Status:</span>
                    <?php
                        $statusConfig = [
                            'menunggu' => ['bg' => 'bg-gray-100 dark:bg-gray-700/50', 'text' => 'text-gray-700 dark:text-gray-300', 'label' => 'Menunggu'],
                            'dalam_proses' => ['bg' => 'bg-yellow-100 dark:bg-yellow-900/40', 'text' => 'text-yellow-700 dark:text-yellow-300', 'label' => 'Dalam Proses'],
                            'selesai' => ['bg' => 'bg-green-100 dark:bg-green-900/40', 'text' => 'text-green-700 dark:text-green-300', 'label' => 'Selesai'],
                            'dibatalkan' => ['bg' => 'bg-red-100 dark:bg-red-900/40', 'text' => 'text-red-700 dark:text-red-300', 'label' => 'Dibatalkan'],
                        ];
                        $status = $statusConfig[$production->status] ?? $statusConfig['menunggu'];
                    ?>
                    <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium rounded-md <?php echo e($status['bg']); ?> <?php echo e($status['text']); ?>">
                        <?php echo e($status['label']); ?>

                    </span>
                </div>
            </div>
        </div>

        <!-- Info Order -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-emerald-100 dark:bg-emerald-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-emerald-600 dark:text-emerald-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Info Pesanan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Order ID:</span>
                    <span class="font-medium text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Produk:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs truncate" title="<?php echo e($production->product->product_title ?? 'N/A'); ?>"><?php echo e(Str::limit($production->product->product_title ?? 'N/A', 15)); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Harga:</span>
                    <span class="font-semibold text-emerald-600 dark:text-emerald-400">Rp <?php echo e(number_format($production->order->price ?? 0, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-chart-pie text-purple-600 dark:text-purple-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Ringkasan</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Bahan:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionMaterials->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Sparepart:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($production->productionSpareparts->count()); ?> item</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Total:</span>
                    <span class="font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($totalCost, 0, ',', '.')); ?></span>
                </div>
            </div>
        </div>

        <!-- Payment Info -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
            <div class="flex items-center gap-2 mb-3">
                <div class="p-2 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                    <i class="fas fa-credit-card text-orange-600 dark:text-orange-400 text-sm"></i>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Pembayaran</h3>
            </div>
            <div class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Metode:</span>
                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e(strtoupper($production->order->payment_method ?? 'N/A')); ?></span>
                </div>
                <?php if($production->submitted_at): ?>
                <div class="flex justify-between">
                    <span class="text-gray-500 dark:text-gray-400">Diajukan:</span>
                    <span class="font-medium text-gray-900 dark:text-white text-xs"><?php echo e($production->submitted_at->format('d/m/Y')); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Timeline Progress -->
    <?php echo $__env->make('supervisor.productions.partials.timeline', ['production' => $production], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    
    
    <?php
        $itemRequests = $production->itemRequests ?? collect();
        $pendingRequests = $itemRequests->where('status', 'pending');
    ?>
    
    <?php if($pendingRequests->count() > 0): ?>
    <div class="bg-orange-50 dark:bg-orange-900/20 border border-orange-200 dark:border-orange-800 rounded-lg overflow-hidden mb-6">
        <div class="px-5 py-4 bg-orange-500 dark:bg-orange-600 text-white flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-white/20 rounded-lg flex items-center justify-center">
                    <i class="fas fa-bell text-white text-sm"></i>
                </div>
                <div>
                    <h3 class="text-base font-semibold">Request Item Menunggu Persetujuan</h3>
                    <p class="text-xs text-orange-100"><?php echo e($pendingRequests->count()); ?> request baru dari teknisi perlu ditinjau</p>
                </div>
            </div>
            <span class="px-3 py-1 bg-white/20 rounded-md text-xs font-semibold animate-pulse"><?php echo e($pendingRequests->count()); ?> Pending</span>
        </div>

        <div class="p-5">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-orange-100 dark:bg-orange-900/30 border-b border-orange-200 dark:border-orange-800">
                        <tr>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Item</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Tipe</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Jumlah</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Satuan</th>
                            <th class="px-4 py-3.5 text-right text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Harga/Unit</th>
                            <th class="px-4 py-3.5 text-right text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Total</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Stok</th>
                            <th class="px-4 py-3.5 text-center text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Status Ketersediaan</th>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Alasan</th>
                            <th class="px-4 py-3.5 text-left text-xs font-semibold text-orange-800 dark:text-orange-200 uppercase">Diminta Oleh</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-orange-200 dark:divide-orange-800 bg-white dark:bg-gray-800">
                        <?php $__currentLoopData = $pendingRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $quantity = (int)$request->quantity;
                            // Ambil harga: prioritas dari relasi material/sparepart, jika tidak ada cari di master berdasarkan nama, terakhir pakai estimated_price
                            $estimatedPrice = 0;
                            if ($request->item_type === 'material' && $request->material) {
                                $estimatedPrice = $request->material->price ?? $request->estimated_price ?? 0;
                            } elseif ($request->item_type === 'sparepart' && $request->sparepart) {
                                $estimatedPrice = $request->sparepart->price ?? $request->estimated_price ?? 0;
                            } else {
                                // Item baru: coba cari di master barang berdasarkan nama
                                if ($request->item_name) {
                                    if ($request->item_type === 'material') {
                                        // Coba exact match dulu
                                        $foundMaterial = \App\Models\Material::where('name', $request->item_name)->first();
                                        // Jika tidak ada, coba partial match
                                        if (!$foundMaterial) {
                                            $foundMaterial = \App\Models\Material::where('name', 'LIKE', '%' . trim($request->item_name) . '%')->first();
                                        }
                                        if ($foundMaterial) {
                                            $estimatedPrice = $foundMaterial->price ?? $request->estimated_price ?? 0;
                                        } else {
                                            $estimatedPrice = $request->estimated_price ?? 0;
                                        }
                                    } else {
                                        // Coba exact match dulu
                                        $foundSparepart = \App\Models\Sparepart::where('name', $request->item_name)->first();
                                        // Jika tidak ada, coba partial match
                                        if (!$foundSparepart) {
                                            $foundSparepart = \App\Models\Sparepart::where('name', 'LIKE', '%' . trim($request->item_name) . '%')->first();
                                        }
                                        if ($foundSparepart) {
                                            $estimatedPrice = $foundSparepart->price ?? $request->estimated_price ?? 0;
                                        } else {
                                            $estimatedPrice = $request->estimated_price ?? 0;
                                        }
                                    }
                                } else {
                                    $estimatedPrice = $request->estimated_price ?? 0;
                                }
                            }
                            $totalPrice = $quantity * $estimatedPrice;
                            // Ambil stok terbaru dari database (fresh)
                            $currentStock = 0;
                            if ($request->item_type === 'material' && $request->material_id) {
                                $material = \App\Models\Material::find($request->material_id);
                                $currentStock = $material ? $material->stock : 0;
                            } elseif ($request->item_type === 'sparepart' && $request->sparepart_id) {
                                $sparepart = \App\Models\Sparepart::find($request->sparepart_id);
                                $currentStock = $sparepart ? $sparepart->stock : 0;
                            }
                            $totalNeeded = $quantity * $orderQty;
                            $stockStatus = 'available';
                            $stockStatusLabel = 'Tersedia';
                            $stockStatusClass = 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300';
                            $stockStatusIcon = 'check-circle';
                            
                            if ($currentStock < $totalNeeded) {
                                if ($currentStock == 0) {
                                    $stockStatus = 'pending_purchase';
                                    $stockStatusLabel = 'Perlu Pembelian';
                                    $stockStatusClass = 'bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300';
                                    $stockStatusIcon = 'times-circle';
                                } else {
                                    $stockStatus = 'insufficient';
                                    $stockStatusLabel = 'Perlu Pembelian (Kurang)';
                                    $stockStatusClass = 'bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300';
                                    $stockStatusIcon = 'exclamation-triangle';
                                }
                            }
                        ?>
                        <tr class="hover:bg-orange-50/50 dark:hover:bg-orange-900/20 transition-colors duration-200">
                            <td class="px-4 py-3.5">
                                <div class="font-medium text-gray-900 dark:text-white text-sm"><?php echo e($request->item_name_display); ?></div>
                                <?php if($request->is_new_item): ?>
                                <span class="text-xs text-blue-600 dark:text-blue-400"><i class="fas fa-star mr-0.5"></i>Item Baru</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-center">
                                <?php if($request->item_type === 'material'): ?>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-emerald-100 dark:bg-emerald-900/40 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-cube text-xs"></i> Bahan
                                </span>
                                <?php else: ?>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                    <i class="fas fa-cog text-xs"></i> Sparepart
                                </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm"><?php echo e($quantity); ?></td>
                            <td class="px-4 py-3.5 text-center text-gray-600 dark:text-gray-400 text-sm"><?php echo e($request->unit); ?></td>
                            <td class="px-4 py-3.5 text-right text-gray-600 dark:text-gray-400 text-sm">
                                <?php if($estimatedPrice > 0): ?>
                                    Rp <?php echo e(number_format($estimatedPrice, 0, ',', '.')); ?>

                                <?php else: ?>
                                    <span class="text-gray-400">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-right font-semibold text-gray-900 dark:text-white text-sm">
                                <?php if($totalPrice > 0): ?>
                                    Rp <?php echo e(number_format($totalPrice, 0, ',', '.')); ?>

                                <?php else: ?>
                                    <span class="text-gray-400">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-center">
                                <div class="flex flex-col items-center gap-1">
                                    <span class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($currentStock); ?></span>
                                    <span class="text-xs text-gray-500">Butuh: <?php echo e($totalNeeded); ?></span>
                                </div>
                            </td>
                            <td class="px-4 py-3.5 text-center">
                                <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-semibold rounded-md <?php echo e($stockStatusClass); ?>">
                                    <i class="fas fa-<?php echo e($stockStatusIcon); ?> text-xs"></i>
                                    <?php echo e($stockStatusLabel); ?>

                                </span>
                                <?php if($stockStatus !== 'available'): ?>
                                <div class="mt-1 text-[10px] text-gray-500">
                                    <?php if($stockStatus === 'insufficient'): ?>
                                    Kurang: <?php echo e($totalNeeded - $currentStock); ?> <?php echo e($request->unit); ?>

                                    <?php else: ?>
                                    Stok: 0
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3.5 text-sm text-gray-600 dark:text-gray-400"><?php echo e(Str::limit($request->reason, 50)); ?></td>
                            <td class="px-4 py-3.5">
                                <div class="text-sm">
                                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e($request->requester->name ?? 'N/A'); ?></span>
                                    <br><span class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($request->created_at->format('d/m/Y H:i')); ?></span>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    
    
    
    <?php
        $itemRequests = $production->itemRequests ?? collect();
        $proposalGroups = $itemRequests->groupBy('proposal_number')->sortKeys();
    ?>
    
    <?php if($proposalGroups->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 mb-6 overflow-hidden">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700 bg-gradient-to-r from-indigo-600 to-indigo-700">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-white/20 rounded-lg">
                        <i class="fas fa-list-ol text-white text-sm"></i>
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-white">Usulan Bahan & Sparepart</h3>
                        <p class="text-xs text-indigo-100">
                            Dikelompokkan berdasarkan usulan pertama, kedua, ketiga
                            <?php if($pendingRequests->count() > 0): ?>
                            · <span class="text-orange-200">Item pending juga ada di notifikasi di atas</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php if($itemRequests->count() > 0): ?>
                <div class="flex items-center gap-2">
                    <div class="flex items-center gap-1.5 px-3 py-1 bg-white/10 rounded-md text-xs">
                        <span class="text-indigo-100">Total:</span>
                        <span class="font-semibold text-white"><?php echo e($itemRequests->count()); ?> item</span>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="p-5 space-y-6">
            <?php $__currentLoopData = $proposalGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proposalNumber => $requests): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 dark:border-gray-700 rounded-lg overflow-hidden">
                <div class="px-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-700">
                    <h4 class="text-sm font-semibold text-gray-900 dark:text-white flex items-center gap-2">
                        <span class="w-6 h-6 rounded-full bg-indigo-100 dark:bg-indigo-900/40 text-indigo-700 dark:text-indigo-300 flex items-center justify-center text-xs font-bold">
                            <?php echo e($proposalNumber ?? '1'); ?>

                        </span>
                        Usulan <?php echo e($proposalNumber == 1 ? 'Pertama' : ($proposalNumber == 2 ? 'Kedua' : ($proposalNumber == 3 ? 'Ketiga' : 'Ke-' . $proposalNumber))); ?>

                        <span class="ml-auto text-xs font-normal text-gray-500">
                            <?php echo e($requests->count()); ?> item
                        </span>
                    </h4>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                            <tr class="text-xs uppercase">
                                <th class="px-4 py-2 text-left font-semibold text-gray-600 dark:text-gray-300">Item</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Tipe</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Jumlah</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Satuan</th>
                                <th class="px-4 py-2 text-right font-semibold text-gray-600 dark:text-gray-300">Harga/Unit</th>
                                <th class="px-4 py-2 text-right font-semibold text-gray-600 dark:text-gray-300">Total</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Stok</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Status Ketersediaan</th>
                                <th class="px-4 py-2 text-left font-semibold text-gray-600 dark:text-gray-300">Alasan</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Status</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Tanggal</th>
                                <th class="px-4 py-2 text-center font-semibold text-gray-600 dark:text-gray-300">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-700 bg-white dark:bg-gray-800">
                            <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $quantity = (int)$request->quantity;
                                // Ambil harga: prioritas dari relasi material/sparepart, jika tidak ada cari di master berdasarkan nama, terakhir pakai estimated_price
                                $estimatedPrice = 0;
                                if ($request->item_type === 'material' && $request->material) {
                                    $estimatedPrice = $request->material->price ?? $request->estimated_price ?? 0;
                                } elseif ($request->item_type === 'sparepart' && $request->sparepart) {
                                    $estimatedPrice = $request->sparepart->price ?? $request->estimated_price ?? 0;
                                } else {
                                    // Item baru: coba cari di master barang berdasarkan nama
                                    if ($request->item_name) {
                                        if ($request->item_type === 'material') {
                                            $foundMaterial = \App\Models\Material::where('name', 'LIKE', '%' . $request->item_name . '%')->first();
                                            if ($foundMaterial) {
                                                $estimatedPrice = $foundMaterial->price ?? $request->estimated_price ?? 0;
                                            } else {
                                                $estimatedPrice = $request->estimated_price ?? 0;
                                            }
                                        } else {
                                            $foundSparepart = \App\Models\Sparepart::where('name', 'LIKE', '%' . $request->item_name . '%')->first();
                                            if ($foundSparepart) {
                                                $estimatedPrice = $foundSparepart->price ?? $request->estimated_price ?? 0;
                                            } else {
                                                $estimatedPrice = $request->estimated_price ?? 0;
                                            }
                                        }
                                    } else {
                                        $estimatedPrice = $request->estimated_price ?? 0;
                                    }
                                }
                                $totalPrice = $quantity * $estimatedPrice;
                                // Ambil stok terbaru dari database (fresh)
                                $currentStock = 0;
                                if ($request->item_type === 'material' && $request->material_id) {
                                    $material = \App\Models\Material::find($request->material_id);
                                    $currentStock = $material ? $material->stock : 0;
                                } elseif ($request->item_type === 'sparepart' && $request->sparepart_id) {
                                    $sparepart = \App\Models\Sparepart::find($request->sparepart_id);
                                    $currentStock = $sparepart ? $sparepart->stock : 0;
                                }
                                $totalNeeded = $quantity * $orderQty;
                                $stockStatus = 'available';
                                $stockStatusLabel = 'Tersedia';
                                $stockStatusClass = 'bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300';
                                $stockStatusIcon = 'check-circle';
                                
                                if ($currentStock < $totalNeeded) {
                                    if ($currentStock == 0) {
                                        $stockStatus = 'pending_purchase';
                                        $stockStatusLabel = 'Perlu Pembelian';
                                        $stockStatusClass = 'bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300';
                                        $stockStatusIcon = 'times-circle';
                                    } else {
                                        $stockStatus = 'insufficient';
                                        $stockStatusLabel = 'Perlu Pembelian (Kurang)';
                                        $stockStatusClass = 'bg-amber-100 dark:bg-amber-900/40 text-amber-700 dark:text-amber-300';
                                        $stockStatusIcon = 'exclamation-triangle';
                                    }
                                }
                            ?>
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 <?php echo e($request->status === 'pending' ? 'bg-orange-50/30 dark:bg-orange-900/10' : ''); ?>">
                                <td class="px-4 py-3">
                                    <div class="font-medium text-gray-900 dark:text-white text-sm flex items-center gap-2">
                                        <?php echo e($request->item_name_display); ?>

                                        <?php if($request->status === 'pending'): ?>
                                        <span class="px-1.5 py-0.5 bg-orange-100 dark:bg-orange-900/40 text-orange-700 dark:text-orange-300 text-[10px] font-medium rounded" title="Juga ada di notifikasi di atas">
                                            <i class="fas fa-bell mr-0.5"></i>Pending
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($request->is_new_item): ?>
                                    <span class="text-xs text-blue-600 dark:text-blue-400"><i class="fas fa-star mr-0.5"></i>Item Baru</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <?php if($request->item_type === 'material'): ?>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-full bg-emerald-100 text-emerald-700">
                                        <i class="fas fa-cube"></i> Bahan
                                    </span>
                                    <?php else: ?>
                                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs font-medium rounded-full bg-blue-100 text-blue-700">
                                        <i class="fas fa-cog"></i> Sparepart
                                    </span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-center font-medium text-gray-900 dark:text-white"><?php echo e($quantity); ?></td>
                                <td class="px-4 py-3 text-center text-gray-600 dark:text-gray-400"><?php echo e($request->unit); ?></td>
                                <td class="px-4 py-3 text-right text-gray-600 dark:text-gray-400 text-sm">
                                    <?php if($estimatedPrice > 0): ?>
                                        Rp <?php echo e(number_format($estimatedPrice, 0, ',', '.')); ?>

                                    <?php else: ?>
                                        <span class="text-gray-400">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-right font-semibold text-gray-900 dark:text-white text-sm">
                                    <?php if($totalPrice > 0): ?>
                                        Rp <?php echo e(number_format($totalPrice, 0, ',', '.')); ?>

                                    <?php else: ?>
                                        <span class="text-gray-400">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <div class="flex flex-col items-center gap-1">
                                        <span class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($currentStock); ?></span>
                                        <span class="text-xs text-gray-500">Butuh: <?php echo e($totalNeeded); ?></span>
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-center">
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 text-xs font-semibold rounded-md <?php echo e($stockStatusClass); ?>">
                                        <i class="fas fa-<?php echo e($stockStatusIcon); ?> text-xs"></i>
                                        <?php echo e($stockStatusLabel); ?>

                                    </span>
                                    <?php if($stockStatus !== 'available'): ?>
                                    <div class="mt-1 text-[10px] text-gray-500">
                                        <?php if($stockStatus === 'insufficient'): ?>
                                        Kurang: <?php echo e($totalNeeded - $currentStock); ?> <?php echo e($request->unit); ?>

                                        <?php else: ?>
                                        Stok: 0
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-600 dark:text-gray-400"><?php echo e(Str::limit($request->reason, 50)); ?></td>
                                <td class="px-4 py-3 text-center">
                                    <span class="inline-flex items-center gap-1 px-2 py-1 text-xs font-medium rounded-full <?php echo e($request->status_badge_class); ?>">
                                        <?php if($request->status === 'pending'): ?>
                                        <i class="fas fa-clock text-[10px]"></i>
                                        <?php elseif($request->status === 'approved'): ?>
                                        <i class="fas fa-check-circle text-[10px]"></i>
                                        <?php elseif($request->status === 'rejected'): ?>
                                        <i class="fas fa-times-circle text-[10px]"></i>
                                        <?php elseif($request->status === 'purchased'): ?>
                                        <i class="fas fa-shopping-cart text-[10px]"></i>
                                        <?php elseif($request->status === 'sent'): ?>
                                        <i class="fas fa-paper-plane text-[10px] animate-pulse"></i>
                                        <?php elseif($request->status === 'received'): ?>
                                        <i class="fas fa-check-double text-[10px]"></i>
                                        <?php endif; ?>
                                        <?php echo e($request->status_label); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 text-center text-xs text-gray-500">
                                    <?php echo e($request->requested_at->format('d/m/Y H:i')); ?>

                                </td>
                                <td class="px-4 py-3 text-center">
                                    <?php if($request->status === 'pending'): ?>
                                    <span class="text-xs text-gray-400 italic">Menunggu Admin</span>
                                    <?php elseif($request->status === 'approved' && !$request->purchase_id): ?>
                                    <span class="text-xs text-gray-400 italic">Menunggu Pembelian</span>
                                    <?php elseif($request->status === 'purchased' && $request->purchase_id): ?>
                                    <span class="text-xs text-gray-400 italic">Menunggu Pengiriman</span>
                                    <?php elseif($request->status === 'sent'): ?>
                                    <span class="text-xs text-indigo-600 dark:text-indigo-400 italic">Dikirim ke Teknisi</span>
                                    <?php elseif($request->status === 'received'): ?>
                                    <span class="text-xs text-green-600 dark:text-green-400 italic">Sudah Diterima</span>
                                    <?php elseif($request->status === 'rejected'): ?>
                                    <span class="text-xs text-red-600 dark:text-red-400 italic">Ditolak</span>
                                    <?php else: ?>
                                    <span class="text-xs text-gray-400">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Tabel Bahan & Sparepart -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="px-5 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-indigo-100 dark:bg-indigo-900/40 rounded-lg">
                    <i class="fas fa-boxes text-indigo-600 dark:text-indigo-400 text-sm"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900 dark:text-white">Daftar Bahan & Sparepart</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400"><?php echo e($production->productionMaterials->count() + $production->productionSpareparts->count()); ?> item · <?php echo e($orderQty); ?> unit produk</p>
                </div>
            </div>
        </div>

        <?php
            $allItems = collect();
            foreach($production->productionMaterials as $pm) {
                // Untuk item request yang sudah diterima (is_additional = true dan is_received = true)
                // Stok di master barang sudah dikurangi saat admin kirim, jadi stok yang ditampilkan
                // adalah stok yang "tersedia untuk produksi" (quantity yang sudah diterima)
                $currentStock = $pm->material->stock ?? 0;
                if ($pm->is_additional && $pm->is_received) {
                    $currentStock = $pm->quantity * $orderQty;
                }
                
                $allItems->push([
                    'type' => 'material',
                    'name' => $pm->material->name ?? 'N/A',
                    'quantity' => $pm->quantity,
                    'unit' => $pm->unit,
                    'unit_cost' => $pm->unit_cost,
                    'total_cost' => $pm->total_cost,
                    'stock' => $currentStock,
                    'is_additional' => $pm->is_additional ?? false,
                    'is_received' => $pm->is_received ?? false,
                ]);
            }
            foreach($production->productionSpareparts as $ps) {
                // Untuk item request yang sudah diterima (is_additional = true dan is_received = true)
                // Stok di master barang sudah dikurangi saat admin kirim, jadi stok yang ditampilkan
                // adalah stok yang "tersedia untuk produksi" (quantity yang sudah diterima)
                $currentStock = $ps->sparepart->stock ?? 0;
                if ($ps->is_additional && $ps->is_received) {
                    $currentStock = $ps->quantity * $orderQty;
                }
                
                $allItems->push([
                    'type' => 'sparepart',
                    'name' => $ps->sparepart->name ?? 'N/A',
                    'quantity' => $ps->quantity,
                    'unit' => $ps->unit,
                    'unit_cost' => $ps->unit_cost,
                    'total_cost' => $ps->total_cost,
                    'stock' => $currentStock,
                    'is_additional' => $ps->is_additional ?? false,
                    'is_received' => $ps->is_received ?? false,
                ]);
            }
        ?>

        <?php if($allItems->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700/50 border-b border-gray-200 dark:border-gray-600">
                    <tr>
                        <th class="px-4 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Nama Item</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Tipe</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Jumlah</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Satuan</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Harga/Unit</th>
                        <th class="px-4 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Total</th>
                        <th class="px-4 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Stok</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $allItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors duration-200">
                        <td class="px-4 py-3.5">
                            <span class="font-medium text-gray-900 dark:text-white text-sm"><?php echo e($item['name']); ?></span>
                        </td>
                        <td class="px-4 py-3.5 text-center">
                            <?php if($item['type'] === 'material'): ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-emerald-100 dark:bg-emerald-900/40 text-emerald-700 dark:text-emerald-300">
                                <i class="fas fa-cube text-xs"></i> Bahan
                            </span>
                            <?php else: ?>
                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-medium rounded-md bg-blue-100 dark:bg-blue-900/40 text-blue-700 dark:text-blue-300">
                                <i class="fas fa-cog text-xs"></i> Sparepart
                            </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3.5 text-center font-medium text-gray-900 dark:text-white text-sm"><?php echo e($item['quantity']); ?></td>
                        <td class="px-4 py-3.5 text-center text-gray-600 dark:text-gray-400 text-sm"><?php echo e($item['unit']); ?></td>
                        <td class="px-4 py-3.5 text-right text-gray-600 dark:text-gray-400 text-sm">Rp <?php echo e(number_format($item['unit_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3.5 text-right font-semibold text-gray-900 dark:text-white text-sm">Rp <?php echo e(number_format($item['total_cost'], 0, ',', '.')); ?></td>
                        <td class="px-4 py-3.5 text-center">
                            <?php if(isset($item['is_additional']) && $item['is_additional'] && isset($item['is_received']) && $item['is_received']): ?>
                            <span class="px-2 py-0.5 text-xs font-medium rounded-full bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300" title="Item Request - Sudah Diterima"><?php echo e($item['stock']); ?> <i class="fas fa-check-circle ml-1"></i></span>
                            <?php elseif($item['stock'] >= $item['quantity'] * $orderQty): ?>
                            <span class="px-2 py-0.5 text-xs font-medium rounded-full bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300"><?php echo e($item['stock']); ?></span>
                            <?php else: ?>
                            <span class="px-2 py-0.5 text-xs font-medium rounded-full bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300"><?php echo e($item['stock']); ?> <i class="fas fa-exclamation-triangle ml-1"></i></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="bg-gray-50 dark:bg-gray-700/50 border-t border-gray-200 dark:border-gray-600">
                    <tr>
                        <td colspan="5" class="px-4 py-3.5">
                            <div class="flex items-center gap-4 text-sm">
                                <span class="inline-flex items-center gap-1 text-emerald-700 dark:text-emerald-300">
                                    <i class="fas fa-cube text-emerald-500"></i> Bahan: Rp <?php echo e(number_format($materialTotal, 0, ',', '.')); ?>

                                </span>
                                <span class="inline-flex items-center gap-1 text-blue-700 dark:text-blue-300">
                                    <i class="fas fa-cog text-blue-500"></i> Sparepart: Rp <?php echo e(number_format($sparepartTotal, 0, ',', '.')); ?>

                                </span>
                            </div>
                        </td>
                        <td class="px-4 py-3.5 text-right font-bold text-gray-900 dark:text-white">
                            Total: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?>

                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        <?php else: ?>
        <div class="p-8 text-center">
            <div class="w-14 h-14 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mx-auto mb-3">
                <i class="fas fa-inbox text-2xl text-gray-400 dark:text-gray-500"></i>
            </div>
            <p class="text-gray-500 dark:text-gray-400">Belum ada bahan atau sparepart ditambahkan</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Labor Cost -->
    <?php if($laborTotal > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-orange-100 dark:bg-orange-900/40 rounded-lg flex items-center justify-center">
                    <i class="fas fa-users text-orange-600 dark:text-orange-400"></i>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900 dark:text-white">Biaya Tenaga Kerja (Labor)</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Upah untuk <?php echo e($orderQty); ?> unit produk</p>
                </div>
            </div>
            <div class="text-right">
                <p class="text-xl font-bold text-orange-600 dark:text-orange-400">Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></p>
                <p class="text-xs text-gray-500 dark:text-gray-400">Per unit: Rp <?php echo e(number_format($laborTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Total Cost Summary - Clean Style -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5">
        <div class="flex items-center justify-between">
            <div>
                <div class="flex items-center gap-2 mb-1">
                    <div class="w-8 h-8 rounded-lg bg-indigo-100 dark:bg-indigo-900/40 flex items-center justify-center">
                        <i class="fas fa-calculator text-indigo-600 dark:text-indigo-400 text-sm"></i>
                    </div>
                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Biaya Produksi</p>
                </div>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?></p>
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    <span class="inline-flex items-center gap-1"><i class="fas fa-cube text-emerald-500"></i> Langsung: Rp <?php echo e(number_format($directTotal, 0, ',', '.')); ?></span>
                    <span class="mx-2">•</span>
                    <span class="inline-flex items-center gap-1"><i class="fas fa-users text-blue-500"></i> Labor: Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></span>
                </p>
            </div>
            <div class="text-right border-l border-gray-200 dark:border-gray-600 pl-5">
                <p class="text-xs font-medium text-gray-500 dark:text-gray-400 mb-1">Per Unit</p>
                <p class="text-xl font-bold text-indigo-600 dark:text-indigo-400">Rp <?php echo e(number_format($actualTotal / max($orderQty, 1), 0, ',', '.')); ?></p>
            </div>
        </div>
    </div>

    <!-- Catatan Teknisi -->
    <?php if($production->notes): ?>
    <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4">
        <h3 class="text-sm font-semibold text-amber-800 mb-2 flex items-center gap-2">
            <i class="fas fa-sticky-note text-amber-600"></i> Catatan dari Teknisi
        </h3>
        <p class="text-sm text-amber-700"><?php echo e($production->notes); ?></p>
    </div>
    <?php endif; ?>

    <!-- Action Buttons -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4">
        <div class="flex flex-wrap gap-3 justify-end items-center">
            <?php if($production->planning_status === 'pending_approval'): ?>
            <div class="flex gap-2">
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveProductionFromBtn(this)"
                        class="px-5 py-2.5 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-check mr-1"></i> Setujui Planning
                </button>
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectProductionFromBtn(this)"
                        class="px-5 py-2.5 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-redo mr-1"></i> Minta Revisi
                </button>
            </div>
            <?php elseif($production->completion_status === 'pending_approval'): ?>
            <div class="flex gap-2">
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveCompletionFromBtn(this)"
                        class="px-5 py-2.5 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-check-double mr-1"></i> Setujui Penyelesaian
                </button>
                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectCompletionFromBtn(this)"
                        class="px-5 py-2.5 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors">
                    <i class="fas fa-redo mr-1"></i> Minta Revisi
                </button>
            </div>
            <?php else: ?>
            <span class="px-4 py-2 bg-gray-100 text-gray-600 rounded-lg text-sm">
                <?php if($production->planning_status === 'approved'): ?>
                    <i class="fas fa-check-circle text-green-500 mr-1"></i> Planning sudah disetujui
                <?php elseif($production->status === 'selesai'): ?>
                    <i class="fas fa-check-double text-green-500 mr-1"></i> Produksi sudah selesai
                <?php else: ?>
                    <i class="fas fa-info-circle mr-1"></i> Tidak ada aksi yang diperlukan
                <?php endif; ?>
            </span>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal Persetujuan Planning -->
<div id="approvalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-circle"></i> Setujui Planning
                </h3>
            </div>
            <form id="approvalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Planning -->
<div id="rejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Planning
                </h3>
            </div>
            <form id="rejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Persetujuan Penyelesaian -->
<div id="completionApprovalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-emerald-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-check-double"></i> Setujui Penyelesaian
                </h3>
            </div>
            <form id="completionApprovalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionApprovalModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium">
                        <i class="fas fa-check mr-1"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Penyelesaian -->
<div id="completionRejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden">
            <div class="px-6 py-4 bg-orange-600">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                    <i class="fas fa-redo"></i> Minta Revisi Penyelesaian
                </h3>
            </div>
            <form id="completionRejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Alasan Revisi <span class="text-red-500">*</span></label>
                    <textarea name="feedback" rows="3" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 dark:bg-gray-700 dark:text-white"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionRejectionModal()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium">
                        <i class="fas fa-redo mr-1"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Planning Modal Functions
function approveProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('approvalForm').action = `/supervisor/productions/${id}/approve`;
    document.getElementById('approvalModal').classList.remove('hidden');
}

function rejectProductionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('rejectionForm').action = `/supervisor/productions/${id}/reject`;
    document.getElementById('rejectionModal').classList.remove('hidden');
}

function closeApprovalModal() {
    document.getElementById('approvalModal').classList.add('hidden');
}

function closeRejectionModal() {
    document.getElementById('rejectionModal').classList.add('hidden');
}

// Completion Modal Functions
function approveCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionApprovalForm').action = `/supervisor/productions/${id}/approve-completion`;
    document.getElementById('completionApprovalModal').classList.remove('hidden');
}

function rejectCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionRejectionForm').action = `/supervisor/productions/${id}/reject-completion`;
    document.getElementById('completionRejectionModal').classList.remove('hidden');
}

function closeCompletionApprovalModal() {
    document.getElementById('completionApprovalModal').classList.add('hidden');
}

function closeCompletionRejectionModal() {
    document.getElementById('completionRejectionModal').classList.add('hidden');
}

// Close on backdrop click
['approvalModal', 'rejectionModal', 'completionApprovalModal', 'completionRejectionModal'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('click', function(e) {
            if (e.target === this) {
                this.classList.add('hidden');
            }
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/productions/show.blade.php ENDPATH**/ ?>