

<?php $__env->startSection('title', 'Neraca Lajur'); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Header -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Neraca Lajur</h1>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                        Laporan neraca lajur (worksheet) untuk periode tertentu
                    </p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('admin.reports.worksheet.export', request()->all())); ?>" class="inline-flex items-center justify-center px-3 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition-colors duration-200 text-sm">
                        <i class="fas fa-file-excel mr-2 text-xs"></i>
                        Export Excel
                    </a>
                </div>
            </div>
        </div>

        <!-- Filter Form -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-6 mb-6">
            <form method="GET" action="<?php echo e(route('admin.reports.worksheet')); ?>" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tanggal Akhir</label>
                    <input type="date" name="end_date" value="<?php echo e(isset($endDate) ? $endDate : date('Y-m-d')); ?>" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Error Message -->
        <?php if(isset($error)): ?>
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4 mb-6">
                <div class="flex items-start">
                    <i class="fas fa-exclamation-circle text-red-600 dark:text-red-400 text-xl mr-3 mt-0.5"></i>
                    <div class="flex-1">
                        <h4 class="text-red-800 dark:text-red-200 font-semibold mb-2">Error</h4>
                        <p class="text-sm text-red-700 dark:text-red-300"><?php echo e($error); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Report Content -->
        <?php if(isset($accounts) && $accounts !== null): ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden">
                <!-- Header Info -->
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
                    <div class="text-center mb-4">
                        <h2 class="text-xl font-bold text-gray-800 dark:text-white">POLJAMTECH</h2>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Jl. Lkr. Barat 3 No.1, Bagan Pete, Kec. Kota Baru, Kota Jambi, Jambi 36361</p>
                    </div>
                    <div class="text-center">
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">NERACA LAJUR</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                            Per <?php echo e(isset($endDate) ? \Carbon\Carbon::parse($endDate)->format('d F Y') : date('d F Y')); ?>

                        </p>
                    </div>
                </div>

                <div class="p-6">
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-300 dark:border-gray-600" style="min-width: 1400px;">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">KODE AKUN</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">NAMA AKUN</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">POS SALDO</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" colspan="2">NERACA SALDO</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" rowspan="2">POS LAPORAN</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-r border-gray-300 dark:border-gray-600" colspan="2">LABA RUGI</th>
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase border-b border-gray-300 dark:border-gray-600" colspan="2">NERACA</th>
                                </tr>
                                <tr>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">DEBET</th>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">KREDIT</th>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">DEBET</th>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">KREDIT</th>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">DEBET</th>
                                    <th class="px-3 py-2 text-center text-xs font-medium border-b border-r border-gray-300 dark:border-gray-600">KREDIT</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($accounts && $accounts->count() > 0): ?>
                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="border-b border-gray-200 dark:border-gray-600">
                                            <td class="px-3 py-2 text-center text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e($account['kd_perk']); ?></td>
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e($account['nama_perkiraan']); ?></td>
                                            <td class="px-3 py-2 text-center text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e($account['balance_position']); ?></td>
                                            <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['trial_balance_debit']) > 0.01 ? number_format($account['trial_balance_debit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['trial_balance_kredit']) > 0.01 ? number_format($account['trial_balance_kredit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-3 py-2 text-center text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e($account['report_position']); ?></td>
                                            <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['profit_loss_debit']) > 0.01 ? number_format($account['profit_loss_debit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['profit_loss_kredit']) > 0.01 ? number_format($account['profit_loss_kredit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['balance_sheet_debit']) > 0.01 ? number_format($account['balance_sheet_debit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                            <td class="px-3 py-2 text-right text-xs border-gray-300 dark:border-gray-600">
                                                <?php echo e(abs($account['balance_sheet_kredit']) > 0.01 ? number_format($account['balance_sheet_kredit'], 0, ',', '.') : '-'); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="10" class="px-4 py-8 text-center text-sm text-gray-500 dark:text-gray-400">
                                            Tidak ada data untuk periode yang dipilih
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                
                                <?php if($accounts && $accounts->count() > 0): ?>
                                    <!-- Total Row -->
                                    <tr class="bg-gray-50 dark:bg-gray-700 font-semibold">
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600" colspan="3">JUMLAH</td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalTrialBalanceDebit ?? 0, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalTrialBalanceKredit ?? 0, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalProfitLossDebit ?? 0, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalProfitLossKredit ?? 0, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalBalanceSheetDebit ?? 0, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-right text-xs border-gray-300 dark:border-gray-600"><?php echo e(number_format($totalBalanceSheetKredit ?? 0, 0, ',', '.')); ?></td>
                                    </tr>
                                    
                                    <!-- Laba (Rugi) Tahun Berjalan -->
                                    <?php if(isset($netProfitLoss) && abs($netProfitLoss) > 0.01): ?>
                                        <tr class="bg-blue-50 dark:bg-blue-900/20">
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600">310-04</td>
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600">LABA (RUGI) TAHUN BERJALAN</td>
                                            <td class="px-3 py-2 text-center text-xs border-r border-gray-300 dark:border-gray-600">KREDIT</td>
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                            <td class="px-3 py-2 text-center text-xs border-r border-gray-300 dark:border-gray-600">NERACA</td>
                                            <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                            <td class="px-3 py-2 text-right text-xs font-semibold border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(number_format($netProfitLoss, 0, ',', '.')); ?>

                                            </td>
                                            <td class="px-3 py-2 text-right text-xs font-semibold border-r border-gray-300 dark:border-gray-600">
                                                <?php echo e(number_format($netProfitLoss, 0, ',', '.')); ?>

                                            </td>
                                            <td class="px-3 py-2 text-xs border-gray-300 dark:border-gray-600"></td>
                                        </tr>
                                    <?php endif; ?>
                                    
                                    <!-- Neraca Saldo Setelah Laba Rugi -->
                                    <?php
                                        $finalBalanceSheetDebit = $totalBalanceSheetDebit ?? 0;
                                        $finalBalanceSheetKredit = ($totalBalanceSheetKredit ?? 0) + ($netProfitLoss ?? 0);
                                    ?>
                                    <tr class="bg-green-50 dark:bg-green-900/20 font-semibold">
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600" colspan="3">Neraca Saldo Setelah Laba Rugi</td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-xs border-r border-gray-300 dark:border-gray-600"></td>
                                        <td class="px-3 py-2 text-right text-xs border-r border-gray-300 dark:border-gray-600"><?php echo e(number_format($finalBalanceSheetDebit, 0, ',', '.')); ?></td>
                                        <td class="px-3 py-2 text-right text-xs border-gray-300 dark:border-gray-600"><?php echo e(number_format($finalBalanceSheetKredit, 0, ',', '.')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-12 text-center">
                <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3 mx-auto">
                    <i class="fas fa-table text-3xl text-gray-400 dark:text-gray-500"></i>
                </div>
                <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak Ada Data</p>
                <p class="text-gray-400 dark:text-gray-500 text-sm">Tidak ada data neraca lajur untuk periode yang dipilih</p>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/admin/reports/worksheet.blade.php ENDPATH**/ ?>