

<?php $__env->startSection('title', 'Laporan Penjualan - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<!-- Meta tag untuk prevent caching -->
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">

<div class="space-y-6">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800 dark:text-white">Laporan Penjualan</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-0.5">
                    Analisis dan monitoring data penjualan produk
                    <?php if(request('start_date') || request('end_date')): ?>
                        | Periode: 
                        <?php echo e(request('start_date') ? \Carbon\Carbon::parse(request('start_date'))->format('d M Y') : 'Awal'); ?> - 
                        <?php echo e(request('end_date') ? \Carbon\Carbon::parse(request('end_date'))->format('d M Y') : 'Akhir'); ?>

                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Penjualan</p>
                    <h2 class="text-xl font-bold text-blue-600 dark:text-blue-400">Rp <?php echo e(number_format($totalSales, 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-blue-100 dark:bg-blue-900/40 rounded-lg">
                    <i class="fas fa-money-bill-wave text-blue-600 dark:text-blue-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Quantity</p>
                    <h2 class="text-xl font-bold text-green-600 dark:text-green-400"><?php echo e(number_format($totalQuantity, 0, ',', '.')); ?> unit</h2>
                </div>
                <div class="p-2.5 bg-green-100 dark:bg-green-900/40 rounded-lg">
                    <i class="fas fa-boxes text-green-600 dark:text-green-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Total Transaksi</p>
                    <h2 class="text-xl font-bold text-purple-600 dark:text-purple-400"><?php echo e(number_format($totalTransactions, 0, ',', '.')); ?></h2>
                </div>
                <div class="p-2.5 bg-purple-100 dark:bg-purple-900/40 rounded-lg">
                    <i class="fas fa-shopping-cart text-purple-600 dark:text-purple-400 text-lg"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 transition-colors duration-300">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-1">Rata-rata/Transaksi</p>
                    <h2 class="text-xl font-bold text-orange-600 dark:text-orange-400">Rp <?php echo e($totalTransactions > 0 ? number_format($totalSales / $totalTransactions, 0, ',', '.') : '0'); ?></h2>
                </div>
                <div class="p-2.5 bg-orange-100 dark:bg-orange-900/40 rounded-lg">
                    <i class="fas fa-chart-line text-orange-600 dark:text-orange-400 text-lg"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-4 mb-4">
        <form method="GET" action="<?php echo e(route('supervisor.reports.sales')); ?>" id="filterForm" class="space-y-4">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="relative">
                    <input type="date" name="start_date" id="startDateInput" value="<?php echo e(request('start_date')); ?>" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Mulai">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <input type="date" name="end_date" id="endDateInput" value="<?php echo e(request('end_date')); ?>" onchange="submitFilter()"
                        class="w-full pl-10 pr-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 transition-colors duration-200 text-sm h-10"
                        placeholder="Tanggal Akhir">
                    <i class="fas fa-calendar-alt absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none"></i>
                </div>

                <div class="relative">
                    <select name="status" id="statusFilter" onchange="submitFilter()" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="selesai" <?php echo e(request('status') == 'selesai' ? 'selected' : ''); ?>>Selesai</option>
                        <option value="dibatalkan" <?php echo e(request('status') == 'dibatalkan' ? 'selected' : ''); ?>>Dibatalkan</option>
                    </select>
                    <i class="fas fa-chevron-down absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500 pointer-events-none text-xs"></i>
                </div>

                <div class="flex items-center gap-2">
                    <button type="button" onclick="submitFilter()" class="flex-1 flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors duration-200 h-10 text-sm">
                        <i class="fas fa-search mr-2 text-xs"></i>
                        Filter
                    </button>
                    <?php if(request()->hasAny(['start_date', 'end_date', 'status'])): ?>
                        <button type="button" onclick="clearAllFilters()" 
                           class="flex items-center justify-center w-10 h-10 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors duration-200"
                           title="Reset filter">
                            <i class="fas fa-redo text-sm"></i>
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>

    <!-- Active Filters Info -->
    <?php if(request()->hasAny(['start_date', 'end_date', 'status'])): ?>
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4">
            <div class="flex flex-wrap items-center gap-2">
                <span class="text-sm font-medium text-blue-800 dark:text-blue-200">Filter Aktif:</span>
                
                <?php if(request('start_date') || request('end_date')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-800 dark:text-orange-200">
                        <i class="fas fa-calendar-alt mr-1"></i>
                        Periode: <?php echo e(request('start_date') ? date('d M Y', strtotime(request('start_date'))) : 'Awal'); ?> - <?php echo e(request('end_date') ? date('d M Y', strtotime(request('end_date'))) : 'Akhir'); ?>

                        <button onclick="clearDateFilter()" class="ml-2 hover:text-orange-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <?php if(request('status')): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                        <i class="fas fa-filter mr-1"></i>
                        Status: <?php echo e(ucfirst(request('status'))); ?>

                        <button onclick="clearFilter('status')" class="ml-2 hover:text-green-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </span>
                <?php endif; ?>
                
                <button onclick="clearAllFilters()" 
                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-800 dark:text-red-200 hover:bg-red-200 dark:hover:bg-red-700 transition-colors">
                    <i class="fas fa-times-circle mr-1"></i>
                    Hapus Semua Filter
                </button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Sales Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden transition-colors duration-300">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-600">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 dark:bg-blue-900/40 rounded-lg mr-2">
                    <i class="fas fa-table text-blue-600 dark:text-blue-400 text-sm"></i>
                </div>
                <h3 class="text-base font-semibold text-gray-800 dark:text-white">Data Penjualan</h3>
            </div>
        </div>
        <div class="overflow-x-auto custom-scrollbar">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Tanggal</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Order ID</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Produk</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Customer</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Quantity</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Harga Satuan</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Total</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold uppercase tracking-wider text-gray-700 dark:text-gray-200">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                            <?php echo e($sale->sale_date ? $sale->sale_date->format('d/m/Y') : '-'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                            #<?php echo e($sale->order_id ?? '-'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                            <?php echo e($sale->product->product_title ?? '-'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                            <?php echo e($sale->user->name ?? $sale->order->customer_name ?? '-'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-900 dark:text-white">
                            <?php echo e(number_format($sale->quantity, 0, ',', '.')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-900 dark:text-white">
                            Rp <?php echo e(number_format($sale->unit_price, 0, ',', '.')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-semibold text-gray-900 dark:text-white">
                            Rp <?php echo e(number_format($sale->total_price, 0, ',', '.')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium
                                <?php if($sale->status === 'selesai'): ?> bg-green-100 dark:bg-green-900/40 text-green-700 dark:text-green-300
                                <?php elseif($sale->status === 'dibatalkan'): ?> bg-red-100 dark:bg-red-900/40 text-red-700 dark:text-red-300
                                <?php else: ?> bg-yellow-100 dark:bg-yellow-900/40 text-yellow-700 dark:text-yellow-300 <?php endif; ?>">
                                <?php echo e(ucfirst($sale->status ?? '-')); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="px-6 py-16 text-center">
                            <div class="flex flex-col items-center justify-center">
                                <div class="w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-full flex items-center justify-center mb-3">
                                    <i class="fas fa-inbox text-3xl text-gray-400 dark:text-gray-500"></i>
                                </div>
                                <p class="text-gray-500 dark:text-gray-400 font-medium mb-1">Tidak ada data penjualan</p>
                                <p class="text-gray-400 dark:text-gray-500 text-sm">Belum ada data penjualan yang ditemukan.</p>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <?php if($sales->hasPages()): ?>
        <div class="mt-6 flex justify-center">
            <?php echo e($sales->onEachSide(1)->links()); ?>

        </div>
    <?php endif; ?>
</div>

<script>
    function submitFilter() {
        const params = new URLSearchParams();
        
        const startDate = document.getElementById('startDateInput')?.value || '';
        const endDate = document.getElementById('endDateInput')?.value || '';
        const status = document.getElementById('statusFilter')?.value || '';
        
        if (startDate) {
            params.append('start_date', startDate);
        }
        if (endDate) {
            params.append('end_date', endDate);
        }
        if (status) {
            params.append('status', status);
        }
        
        const url = '<?php echo e(route("supervisor.reports.sales")); ?>' + (params.toString() ? '?' + params.toString() : '');
        window.location.href = url;
    }

    function clearFilter(filterName) {
        const url = new URL(window.location);
        url.searchParams.delete(filterName);
        window.location.href = url.toString();
    }

    function clearDateFilter() {
        const url = new URL(window.location);
        url.searchParams.delete('start_date');
        url.searchParams.delete('end_date');
        window.location.href = url.toString();
    }

    function clearAllFilters() {
        window.location.href = '<?php echo e(route("supervisor.reports.sales")); ?>';
    }
</script>

<style>
    .form-select {
        height: 40px !important;
        min-height: 40px !important;
        max-height: 40px !important;
        box-sizing: border-box !important;
        line-height: 1.5 !important;
        padding: 0 2.5rem 0 1rem !important;
        margin: 0 !important;
        width: 100%;
        border: 1px solid rgb(209 213 219);
        border-radius: 0.5rem;
        background-color: white;
        color: rgb(17 24 39);
        font-size: 0.875rem;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        transition: all 0.2s;
    }
    
    .dark .form-select {
        border-color: rgb(75 85 99);
        background-color: rgb(55 65 81);
        color: white;
    }
    
    .form-select:focus {
        outline: none;
        ring: 2px;
        ring-color: rgb(59 130 246);
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/reports/sales.blade.php ENDPATH**/ ?>