

<?php $__env->startSection('title', 'Persetujuan Penyelesaian - Supervisor'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white tracking-tight">Persetujuan Penyelesaian</h1>
            <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1.5">Review dan setujui penyelesaian produksi dari teknisi</p>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Menunggu Persetujuan</p>
                    <p class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($pendingCompletion->count()); ?></p>
                </div>
                <div class="p-3.5 bg-purple-100 dark:bg-purple-900/40 rounded-xl">
                    <i class="fas fa-check-double text-purple-600 dark:text-purple-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Total Produksi</p>
                    <p class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($pendingCompletion->count()); ?></p>
                </div>
                <div class="p-3.5 bg-blue-100 dark:bg-blue-900/40 rounded-xl">
                    <i class="fas fa-industry text-blue-600 dark:text-blue-400 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 p-5 shadow-sm hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs font-medium text-gray-600 dark:text-gray-400 uppercase tracking-wide mb-1">Status</p>
                    <p class="text-lg font-semibold text-emerald-600 dark:text-emerald-400">Aktif</p>
                </div>
                <div class="p-3.5 bg-emerald-100 dark:bg-emerald-900/40 rounded-xl">
                    <i class="fas fa-check-circle text-emerald-600 dark:text-emerald-400 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Pending Completion Table -->
    <?php if($pendingCompletion->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden shadow-sm">
        <div class="px-6 py-4 bg-gradient-to-r from-purple-50 to-indigo-50 dark:from-gray-700 dark:to-gray-700 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                    <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                        <i class="fas fa-check-double text-purple-600 dark:text-purple-400"></i>
                    </div>
                    Menunggu Persetujuan Penyelesaian
                </h2>
                <span class="px-3 py-1.5 bg-purple-600 text-white text-xs font-bold rounded-full"><?php echo e($pendingCompletion->count()); ?> item</span>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full table-auto">
                <thead class="bg-gray-50 dark:bg-gray-700/50">
                    <tr>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">ID</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Produk</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Pesanan</th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Teknisi</th>
                        <th class="px-6 py-3.5 text-right text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Total Biaya</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Selesai</th>
                        <th class="px-6 py-3.5 text-center text-xs font-semibold text-gray-600 dark:text-gray-300 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                <?php $__currentLoopData = $pendingCompletion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $orderQty = $production->quantity ?? $production->order->quantity ?? 1;
                    $materialTotal = $production->total_material_cost ?? 0;
                    $sparepartTotal = $production->total_sparepart_cost ?? 0;
                    $directTotal = $materialTotal + $sparepartTotal;
                    $laborTotal = $production->labor_cost ?? 0;
                    $actualTotal = $directTotal + $laborTotal;
                ?>
                    <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-700/30 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-sm font-semibold bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-white">
                                #<?php echo e($production->id); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="font-medium text-gray-900 dark:text-white text-sm">
                                <?php echo e(Str::limit($production->product->product_title ?? 'N/A', 35)); ?>

                            </div>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e($orderQty); ?> unit</div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900 dark:text-white">#<?php echo e($production->order->id ?? 'N/A'); ?></div>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e(Str::limit($production->order->customer_name ?? 'N/A', 20)); ?></div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 bg-blue-100 dark:bg-blue-900/40 rounded-full flex items-center justify-center">
                                    <i class="fas fa-user text-blue-600 dark:text-blue-400 text-xs"></i>
                                </div>
                                <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e(Str::limit($production->teknisi->name ?? 'N/A', 20)); ?></div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right">
                            <div class="text-sm font-semibold text-gray-900 dark:text-white">Rp <?php echo e(number_format($actualTotal, 0, ',', '.')); ?></div>
                            <?php if($laborTotal > 0): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">Upah: Rp <?php echo e(number_format($laborTotal, 0, ',', '.')); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-center">
                            <div class="text-xs font-medium text-gray-900 dark:text-white"><?php echo e($production->completed_at?->format('d M Y') ?? '-'); ?></div>
                            <?php if($production->completed_at): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e($production->completed_at->diffForHumans()); ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex justify-center items-center gap-2">
                                <a href="<?php echo e(route('supervisor.productions.show', $production->id)); ?>" 
                                   class="w-10 h-10 flex items-center justify-center text-blue-600 bg-blue-50 dark:bg-blue-900/30 hover:bg-blue-100 dark:hover:bg-blue-900/50 rounded-lg transition-all duration-200 border border-blue-200 dark:border-blue-700 hover:scale-105"
                                   title="Lihat Detail">
                                    <i class="fas fa-eye text-sm"></i>
                                </a>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="approveCompletionFromBtn(this)"
                                        class="w-10 h-10 flex items-center justify-center bg-emerald-500 hover:bg-emerald-600 text-white rounded-lg transition-all duration-200 shadow-sm hover:shadow-md hover:scale-105"
                                        title="Setujui">
                                    <i class="fas fa-check text-sm"></i>
                                </button>
                                <button type="button" data-id="<?php echo e($production->id); ?>" onclick="rejectCompletionFromBtn(this)"
                                        class="w-10 h-10 flex items-center justify-center bg-orange-500 hover:bg-orange-600 text-white rounded-lg transition-all duration-200 shadow-sm hover:shadow-md hover:scale-105"
                                        title="Revisi">
                                    <i class="fas fa-undo text-sm"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-12 text-center">
        <div class="w-16 h-16 bg-emerald-100 dark:bg-emerald-900/30 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-check-circle text-3xl text-emerald-500 dark:text-emerald-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Tidak Ada Penyelesaian Menunggu</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400">Semua penyelesaian produksi sudah diproses</p>
    </div>
    <?php endif; ?>
</div>

<!-- Modal Persetujuan Penyelesaian -->
<div id="completionApprovalModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50 transition-opacity duration-300">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden transform transition-all duration-300 scale-95" id="approvalModalContent">
            <div class="px-6 py-4 bg-gradient-to-r from-emerald-600 to-emerald-700">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2.5">
                    <i class="fas fa-check-double"></i> Setujui Penyelesaian
                </h3>
            </div>
            <form id="completionApprovalForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-5">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2.5">Catatan (Opsional)</label>
                    <textarea name="feedback" rows="4" 
                            class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 dark:bg-gray-700 dark:text-white transition-colors"
                            placeholder="Berikan catatan untuk teknisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionApprovalModal()" class="px-5 py-2.5 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 rounded-lg font-medium transition-colors duration-200">Batal</button>
                    <button type="submit" class="px-5 py-2.5 bg-emerald-600 hover:bg-emerald-700 text-white rounded-lg font-medium transition-colors duration-200 shadow-sm hover:shadow-md">
                        <i class="fas fa-check mr-1.5"></i> Setujui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Penolakan Penyelesaian -->
<div id="completionRejectionModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50 transition-opacity duration-300">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl max-w-md w-full overflow-hidden transform transition-all duration-300 scale-95" id="rejectionModalContent">
            <div class="px-6 py-4 bg-gradient-to-r from-orange-600 to-orange-700">
                <h3 class="text-lg font-semibold text-white flex items-center gap-2.5">
                    <i class="fas fa-redo"></i> Minta Revisi Penyelesaian
                </h3>
            </div>
            <form id="completionRejectionForm" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="mb-5">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2.5">
                        Alasan Revisi <span class="text-red-500">*</span>
                    </label>
                    <textarea name="feedback" rows="4" required
                            class="w-full px-4 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 dark:bg-gray-700 dark:text-white transition-colors"
                            placeholder="Jelaskan alasan mengapa perlu direvisi..."></textarea>
                </div>
                <div class="flex justify-end gap-3">
                    <button type="button" onclick="closeCompletionRejectionModal()" class="px-5 py-2.5 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 rounded-lg font-medium transition-colors duration-200">Batal</button>
                    <button type="submit" class="px-5 py-2.5 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors duration-200 shadow-sm hover:shadow-md">
                        <i class="fas fa-redo mr-1.5"></i> Minta Revisi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Toast notification modern
function showToast(message, type = 'success') {
    const styles = {
        success: { border: '#10b981', bg: '#ecfdf5', text: '#065f46', icon: 'check-circle', iconColor: '#10b981' },
        error: { border: '#ef4444', bg: '#fef2f2', text: '#991b1b', icon: 'times-circle', iconColor: '#ef4444' },
        warning: { border: '#f59e0b', bg: '#fffbeb', text: '#92400e', icon: 'exclamation-triangle', iconColor: '#f59e0b' },
        info: { border: '#3b82f6', bg: '#eff6ff', text: '#1e40af', icon: 'info-circle', iconColor: '#3b82f6' }
    };
    const s = styles[type] || styles.success;
    
    const toast = document.createElement('div');
    toast.style.cssText = `
        position: fixed; top: 20px; right: 20px; z-index: 9999;
        display: flex; align-items: center; gap: 12px;
        padding: 14px 20px; border-radius: 12px;
        background: ${s.bg}; border-left: 4px solid ${s.border};
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transform: translateX(120%); transition: transform 0.3s ease;
    `;
    toast.innerHTML = `
        <i class="fas fa-${s.icon}" style="color: ${s.iconColor}; font-size: 18px;"></i>
        <span style="color: ${s.text}; font-weight: 500; font-size: 14px;">${message}</span>
        <button onclick="this.parentElement.remove()" style="margin-left: 8px; color: ${s.text}; opacity: 0.5; cursor: pointer; background: none; border: none;">
            <i class="fas fa-times"></i>
        </button>
    `;
    document.body.appendChild(toast);
    
    requestAnimationFrame(() => { toast.style.transform = 'translateX(0)'; });
    setTimeout(() => {
        toast.style.transform = 'translateX(120%)';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}

// Completion Modal Functions
function approveCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return;
    document.getElementById('completionApprovalForm').action = `/supervisor/productions/${id}/approve-completion`;
    const modal = document.getElementById('completionApprovalModal');
    const content = document.getElementById('approvalModalContent');
    modal.classList.remove('hidden');
    setTimeout(() => {
        content.style.transform = 'scale(1)';
    }, 10);
}

function rejectCompletionFromBtn(btn) {
    const id = btn.dataset.id;
    if (!id) return; 
    document.getElementById('completionRejectionForm').action = `/supervisor/productions/${id}/reject-completion`;
    const modal = document.getElementById('completionRejectionModal');
    const content = document.getElementById('rejectionModalContent');
    modal.classList.remove('hidden');
    setTimeout(() => {
        content.style.transform = 'scale(1)';
    }, 10);
}

function closeCompletionApprovalModal() {
    const modal = document.getElementById('completionApprovalModal');
    const content = document.getElementById('approvalModalContent');
    content.style.transform = 'scale(0.95)';
    setTimeout(() => {
        modal.classList.add('hidden');
    }, 200);
}

function closeCompletionRejectionModal() {
    const modal = document.getElementById('completionRejectionModal');
    const content = document.getElementById('rejectionModalContent');
    content.style.transform = 'scale(0.95)';
    setTimeout(() => {
        modal.classList.add('hidden');
    }, 200);
}

// Close on backdrop click
['completionApprovalModal', 'completionRejectionModal'].forEach(id => {
    const el = document.getElementById(id);
    if (el) {
        el.addEventListener('click', function(e) {
            if (e.target === this) {
                if (id === 'completionApprovalModal') {
                    closeCompletionApprovalModal();
                } else {
                    closeCompletionRejectionModal();
                }
            }
        });
    }
});

// Form submission dengan notifikasi
document.querySelectorAll('#completionApprovalForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Penyelesaian berhasil disetujui!', 'success'), 500);
    });
});

document.querySelectorAll('#completionRejectionForm').forEach(form => {
    form.addEventListener('submit', function() {
        setTimeout(() => showToast('Permintaan revisi berhasil dikirim', 'warning'), 500);
    });
});

// Show flash message if exists
<?php if(session('success')): ?>
    showToast('<?php echo e(session('success')); ?>', 'success');
<?php endif; ?>
<?php if(session('error')): ?>
    showToast('<?php echo e(session('error')); ?>', 'error');
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.supervisor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/supervisor/productions/completion/index.blade.php ENDPATH**/ ?>