<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .content {
            padding: 30px 20px;
        }
        .alert {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .alert strong {
            color: #92400e;
        }
        .password-box {
            background-color: #f3f4f6;
            border: 2px dashed #6b7280;
            padding: 20px;
            text-align: center;
            margin: 20px 0;
            border-radius: 8px;
        }
        .password-box .password {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            font-family: 'Courier New', monospace;
            letter-spacing: 2px;
        }
        .warning {
            background-color: #fee2e2;
            border-left: 4px solid #ef4444;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .warning strong {
            color: #991b1b;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #3b82f6;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
            font-weight: 600;
        }
        .footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            color: #6b7280;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>POLJAM TECH</h1>
        </div>
        <div class="content">
            <h2>Password Anda Telah Direset</h2>
            <p>Halo <strong><?php echo e($user->name); ?></strong>,</p>
            
            <p>Administrator telah mereset password akun Anda. Ini biasanya dilakukan karena:</p>
            <ul>
                <li>Anda meminta bantuan untuk mereset password</li>
                <li>Masalah keamanan terdeteksi pada akun Anda</li>
                <li>Proses onboarding akun baru</li>
            </ul>

            <div class="alert">
                <strong>⚠️ PENTING:</strong> Password baru Anda adalah:
            </div>

            <div class="password-box">
                <div class="password"><?php echo e($newPassword); ?></div>
            </div>

            <div class="warning">
                <strong>🔒 KEAMANAN:</strong> 
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Anda <strong>WAJIB</strong> mengganti password ini saat login pertama kali</li>
                    <li>Jangan bagikan password ini kepada siapapun</li>
                    <li>Gunakan password yang kuat dan unik</li>
                    <li>Jangan gunakan password yang sama dengan akun lain</li>
                </ul>
            </div>

            <p style="margin-top: 30px;">
                <a href="<?php echo e(route('login')); ?>" class="button">Login Sekarang</a>
            </p>

            <p style="margin-top: 30px; color: #6b7280; font-size: 14px;">
                Jika Anda tidak meminta reset password ini, segera hubungi administrator dan ubah password Anda.
            </p>
        </div>
        <div class="footer">
            <p>Email ini dikirim secara otomatis oleh sistem POLJAM TECH. Jangan balas email ini.</p>
            <p>&copy; <?php echo e(date('Y')); ?> POLJAM TECH. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

<?php /**PATH /home/mikr8192/public_html/poljamtech.mikromart.org/poljamtech/resources/views/emails/password-reset-by-admin.blade.php ENDPATH**/ ?>